/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.popup;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.annotation.StyleRes;
import cn.qqtheme.framework.util.LogUtils;
import cn.qqtheme.framework.util.ScreenUtils;

public abstract class BasicPopup<V extends View>
implements DialogInterface.OnKeyListener,
DialogInterface.OnDismissListener {
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    protected Activity activity;
    protected int screenWidthPixels;
    protected int screenHeightPixels;
    private Dialog dialog;
    private FrameLayout contentLayout;
    private boolean isPrepared = false;

    public BasicPopup(Activity activity) {
        this.activity = activity;
        DisplayMetrics metrics = ScreenUtils.displayMetrics((Context)activity);
        this.screenWidthPixels = metrics.widthPixels;
        this.screenHeightPixels = metrics.heightPixels;
        this.initDialog();
    }

    private void initDialog() {
        this.contentLayout = new FrameLayout((Context)this.activity);
        this.contentLayout.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.contentLayout.setFocusable(true);
        this.contentLayout.setFocusableInTouchMode(true);
        this.dialog = new Dialog((Context)this.activity);
        this.dialog.setCanceledOnTouchOutside(true);
        this.dialog.setCancelable(true);
        this.dialog.setOnKeyListener((DialogInterface.OnKeyListener)this);
        this.dialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
        Window window = this.dialog.getWindow();
        if (window != null) {
            window.setGravity(80);
            window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            window.requestFeature(1);
            window.setContentView((View)this.contentLayout);
        }
        this.setSize(this.screenWidthPixels, -2);
    }

    public int getScreenWidthPixels() {
        return this.screenWidthPixels;
    }

    public int getScreenHeightPixels() {
        return this.screenHeightPixels;
    }

    protected abstract V makeContentView();

    public void setFillScreen(boolean fillScreen) {
        if (fillScreen) {
            this.setSize(this.screenWidthPixels, (int)((float)this.screenHeightPixels * 0.85f));
        }
    }

    public void setHalfScreen(boolean halfScreen) {
        if (halfScreen) {
            this.setSize(this.screenWidthPixels, this.screenHeightPixels / 2);
        }
    }

    public void setGravity(int gravity) {
        Window window = this.dialog.getWindow();
        if (window != null) {
            window.setGravity(gravity);
        }
        if (gravity == 17) {
            this.setWidth((int)((float)this.screenWidthPixels * 0.7f));
        }
    }

    protected void setContentViewBefore() {
    }

    protected void setContentViewAfter(V contentView) {
    }

    public void setContentView(View view) {
        this.contentLayout.removeAllViews();
        this.contentLayout.addView(view);
    }

    public void setFitsSystemWindows(boolean flag) {
        this.contentLayout.setFitsSystemWindows(flag);
    }

    public void setAnimationStyle(@StyleRes int animRes) {
        Window window = this.dialog.getWindow();
        if (window != null) {
            window.setWindowAnimations(animRes);
        }
    }

    public void setCanceledOnTouchOutside(boolean flag) {
        this.dialog.setCanceledOnTouchOutside(flag);
    }

    public void setCancelable(boolean flag) {
        this.dialog.setCancelable(flag);
    }

    public void setOnDismissListener(final DialogInterface.OnDismissListener onDismissListener) {
        this.dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                BasicPopup.this.onDismiss(dialog);
                onDismissListener.onDismiss(dialog);
            }
        });
        LogUtils.verbose(this, "popup setOnDismissListener");
    }

    public void setOnKeyListener(final DialogInterface.OnKeyListener onKeyListener) {
        this.dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                BasicPopup.this.onKey(dialog, keyCode, event);
                return onKeyListener.onKey(dialog, keyCode, event);
            }
        });
        LogUtils.verbose(this, "popup setOnKeyListener");
    }

    public void setSize(int width, int height) {
        if (width == -1) {
            width = this.screenWidthPixels;
        }
        if (width == 0 && height == 0) {
            width = this.screenWidthPixels;
            height = -2;
        } else if (width == 0) {
            width = this.screenWidthPixels;
        } else if (height == 0) {
            height = -2;
        }
        LogUtils.verbose(this, String.format("will set popup width/height to: %s/%s", width, height));
        ViewGroup.LayoutParams params = this.contentLayout.getLayoutParams();
        if (params == null) {
            params = new ViewGroup.LayoutParams(width, height);
        } else {
            params.width = width;
            params.height = height;
        }
        this.contentLayout.setLayoutParams(params);
    }

    public void setWidth(int width) {
        this.setSize(width, 0);
    }

    public void setHeight(int height) {
        this.setSize(0, height);
    }

    public void setPrepared(boolean prepared) {
        this.isPrepared = prepared;
    }

    public boolean isShowing() {
        return this.dialog.isShowing();
    }

    public final void show() {
        if (this.isPrepared) {
            this.dialog.show();
            this.showAfter();
            return;
        }
        LogUtils.verbose(this, "do something before popup show");
        this.setContentViewBefore();
        V view = this.makeContentView();
        this.setContentView((View)view);
        this.setContentViewAfter(view);
        this.isPrepared = true;
        this.dialog.show();
        this.showAfter();
    }

    protected void showAfter() {
        LogUtils.verbose(this, "popup show");
    }

    public void dismiss() {
        this.dismissImmediately();
    }

    protected final void dismissImmediately() {
        this.dialog.dismiss();
        LogUtils.verbose(this, "popup dismiss");
    }

    public boolean onBackPress() {
        this.dismiss();
        return false;
    }

    public final boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
        if (event.getAction() == 0 && keyCode == 4) {
            this.onBackPress();
        }
        return false;
    }

    public void onDismiss(DialogInterface dialog) {
        this.dismiss();
    }

    public Context getContext() {
        return this.dialog.getContext();
    }

    public Window getWindow() {
        return this.dialog.getWindow();
    }

    public View getContentView() {
        return this.contentLayout.getChildAt(0);
    }

    public ViewGroup getRootView() {
        return this.contentLayout;
    }
}

