/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.popup;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.CallSuper;
import android.support.annotation.StyleRes;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import cn.qqtheme.framework.popup.PopupDialog;
import cn.qqtheme.framework.util.LogUtils;
import cn.qqtheme.framework.util.ScreenUtils;

public abstract class BasicPopup<V extends View>
implements DialogInterface.OnKeyListener {
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    protected Activity activity;
    protected int screenWidthPixels;
    protected int screenHeightPixels;
    private PopupDialog popupDialog;
    private int width = 0;
    private int height = 0;
    private boolean isFillScreen = false;
    private boolean isHalfScreen = false;
    private boolean isPrepared = false;
    private int gravity = 80;

    public BasicPopup(Activity activity) {
        this.activity = activity;
        DisplayMetrics displayMetrics = ScreenUtils.displayMetrics((Context)activity);
        this.screenWidthPixels = displayMetrics.widthPixels;
        this.screenHeightPixels = displayMetrics.heightPixels;
        this.popupDialog = new PopupDialog((Context)activity);
        this.popupDialog.setOnKeyListener(this);
    }

    public int getScreenWidthPixels() {
        return this.screenWidthPixels;
    }

    public int getScreenHeightPixels() {
        return this.screenHeightPixels;
    }

    protected abstract V makeContentView();

    private void onShowPrepare() {
        if (this.isPrepared) {
            return;
        }
        this.popupDialog.getWindow().setGravity(this.gravity);
        this.setContentViewBefore();
        V view = this.makeContentView();
        this.popupDialog.setContentView((View)view);
        this.setContentViewAfter(view);
        LogUtils.verbose(this, "do something before popup show");
        if (this.width == 0 && this.height == 0) {
            this.width = this.screenWidthPixels;
            this.height = this.isFillScreen ? -1 : (this.isHalfScreen ? this.screenHeightPixels / 2 : -2);
        } else if (this.width == 0) {
            this.width = this.screenWidthPixels;
        } else if (this.height == 0) {
            this.height = -2;
        }
        this.popupDialog.setSize(this.width, this.height);
        this.isPrepared = true;
    }

    public void setFillScreen(boolean fillScreen) {
        this.isFillScreen = fillScreen;
    }

    public void setHalfScreen(boolean halfScreen) {
        this.isHalfScreen = halfScreen;
    }

    public void setGravity(int gravity) {
        this.gravity = gravity;
        if (gravity == 17) {
            this.setWidth((int)((double)this.screenWidthPixels * 0.7));
        }
    }

    protected void setContentViewBefore() {
    }

    protected void setContentViewAfter(V contentView) {
    }

    public void setAnimationStyle(@StyleRes int animRes) {
        this.popupDialog.setAnimationStyle(animRes);
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.popupDialog.setOnDismissListener(onDismissListener);
        LogUtils.verbose(this, "popup setOnDismissListener");
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isShowing() {
        return this.popupDialog.isShowing();
    }

    @CallSuper
    public void show() {
        this.onShowPrepare();
        this.popupDialog.show();
        LogUtils.verbose(this, "popup show");
    }

    public void dismiss() {
        this.popupDialog.dismiss();
        LogUtils.verbose(this, "popup dismiss");
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }

    public final boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
        if (event.getAction() == 0) {
            return this.onKeyDown(keyCode, event);
        }
        return false;
    }

    public Context getContext() {
        return this.popupDialog.getContext();
    }

    public Window getWindow() {
        return this.popupDialog.getWindow();
    }

    public View getContentView() {
        this.onShowPrepare();
        return this.popupDialog.getContentView();
    }

    public ViewGroup getRootView() {
        return this.popupDialog.getRootView();
    }
}

