/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.util;

import android.os.Debug;
import android.os.Environment;
import android.util.Log;
import cn.qqtheme.framework.AppConfig;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class LogUtils {
    private static final int MIN_STACK_OFFSET = 3;
    private static final int MAX_STACK_TRACE_SIZE = 131071;
    private static final int METHOD_COUNT = 2;
    private static boolean isDebug = AppConfig.DEBUG_ENABLE;
    private static String debugTag = AppConfig.DEBUG_TAG;

    public static void verbose(String message) {
        LogUtils.verbose("", message);
    }

    public static void verbose(Object object, String message) {
        LogUtils.verbose(object.getClass().getSimpleName(), message);
    }

    public static void verbose(String tag, String message) {
        if (isDebug) {
            tag = debugTag + (tag == null || tag.trim().length() == 0 ? "" : "-") + tag;
            String msg = message + LogUtils.getTraceElement();
            try {
                Log.v((String)tag, (String)msg);
            }
            catch (Exception e) {
                System.out.println(tag + ">>>" + msg);
            }
        }
    }

    public static void debug(String message) {
        LogUtils.debug("", message);
    }

    public static void debug(Object object, String message) {
        LogUtils.debug(object.getClass().getSimpleName(), message);
    }

    public static void debug(String tag, String message) {
        if (isDebug) {
            tag = debugTag + (tag == null || tag.trim().length() == 0 ? "" : "-") + tag;
            String msg = message + LogUtils.getTraceElement();
            try {
                Log.d((String)tag, (String)msg);
            }
            catch (Exception e) {
                System.out.println(tag + ">>>" + msg);
            }
        }
    }

    public static void warn(Throwable e) {
        LogUtils.warn(LogUtils.toStackTraceString(e));
    }

    public static void warn(String message) {
        LogUtils.warn("", message);
    }

    public static void warn(Object object, String message) {
        LogUtils.warn(object.getClass().getSimpleName(), message);
    }

    public static void warn(Object object, Throwable e) {
        LogUtils.warn(object.getClass().getSimpleName(), LogUtils.toStackTraceString(e));
    }

    public static void warn(String tag, String message) {
        if (isDebug) {
            tag = debugTag + (tag == null || tag.trim().length() == 0 ? "" : "-") + tag;
            String msg = message + LogUtils.getTraceElement();
            try {
                Log.w((String)tag, (String)msg);
            }
            catch (Exception e) {
                System.out.println(tag + ">>>" + msg);
            }
        }
    }

    public static void error(Throwable e) {
        LogUtils.error(LogUtils.toStackTraceString(e));
    }

    public static void error(String message) {
        LogUtils.error("", message);
    }

    public static void error(Object object, String message) {
        LogUtils.error(object.getClass().getSimpleName(), message);
    }

    public static void error(Object object, Throwable e) {
        LogUtils.error(object.getClass().getSimpleName(), LogUtils.toStackTraceString(e));
    }

    public static void error(String tag, String message) {
        if (isDebug) {
            tag = debugTag + (tag == null || tag.trim().length() == 0 ? "" : "-") + tag;
            String msg = message + LogUtils.getTraceElement();
            try {
                Log.e((String)tag, (String)msg);
            }
            catch (Exception e) {
                System.err.println(tag + ">>>" + msg);
            }
        }
    }

    public static void startMethodTracing() {
        if (isDebug) {
            Debug.startMethodTracing((String)(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + debugTag + ".trace"));
        }
    }

    public static void stopMethodTracing() {
        if (isDebug) {
            Debug.stopMethodTracing();
        }
    }

    public static String toStackTraceString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        String stackTraceString = sw.toString();
        if (stackTraceString.length() > 131071) {
            String disclaimer = " [stack trace too large]";
            stackTraceString = stackTraceString.substring(0, 131071 - disclaimer.length()) + disclaimer;
        }
        return stackTraceString;
    }

    private static String getTraceElement() {
        try {
            int methodCount = 2;
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            int stackOffset = LogUtils._getStackOffset(trace);
            if (methodCount + stackOffset > trace.length) {
                methodCount = trace.length - stackOffset - 1;
            }
            String level = "    ";
            StringBuilder builder = new StringBuilder();
            for (int i = methodCount; i > 0; --i) {
                int stackIndex = i + stackOffset;
                if (stackIndex >= trace.length) continue;
                builder.append("\n").append(level).append(LogUtils._getSimpleClassName(trace[stackIndex].getClassName())).append(".").append(trace[stackIndex].getMethodName()).append(" ").append("(").append(trace[stackIndex].getFileName()).append(":").append(trace[stackIndex].getLineNumber()).append(")");
                level = level + "    ";
            }
            return builder.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static int _getStackOffset(StackTraceElement[] trace) {
        for (int i = 3; i < trace.length; ++i) {
            StackTraceElement e = trace[i];
            String name = e.getClassName();
            if (name.equals(LogUtils.class.getName())) continue;
            return --i;
        }
        return -1;
    }

    private static String _getSimpleClassName(String name) {
        int lastIndex = name.lastIndexOf(".");
        return name.substring(lastIndex + 1);
    }
}

