/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.popup;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.qqtheme.framework.popup.BottomPopup;
import cn.qqtheme.framework.util.ConvertUtils;

public abstract class ConfirmPopup<V extends View>
extends BottomPopup<View> {
    protected boolean topLineVisible = true;
    protected int topLineColor = -2236963;
    protected int topBackgroundColor = -1;
    protected boolean cancelVisible = true;
    protected CharSequence cancelText = "";
    protected CharSequence submitText = "";
    protected CharSequence titleText = "";
    protected int cancelTextColor = -16777216;
    protected int submitTextColor = -16777216;
    protected int titleTextColor = -16777216;

    public ConfirmPopup(Activity activity) {
        super(activity);
        this.cancelText = activity.getString(0x1040000);
        this.submitText = activity.getString(17039370);
    }

    public void setTopLineColor(@ColorInt int topLineColor) {
        this.topLineColor = topLineColor;
    }

    public void setTopBackgroundColor(@ColorInt int topBackgroundColor) {
        this.topBackgroundColor = topBackgroundColor;
    }

    public void setTopLineVisible(boolean topLineVisible) {
        this.topLineVisible = topLineVisible;
    }

    public void setCancelVisible(boolean cancelVisible) {
        this.cancelVisible = cancelVisible;
    }

    public void setCancelText(CharSequence cancelText) {
        this.cancelText = cancelText;
    }

    public void setCancelText(@StringRes int textRes) {
        this.cancelText = this.activity.getString(textRes);
    }

    public void setSubmitText(CharSequence submitText) {
        this.submitText = submitText;
    }

    public void setSubmitText(@StringRes int textRes) {
        this.submitText = this.activity.getString(textRes);
    }

    public void setTitleText(CharSequence titleText) {
        this.titleText = titleText;
    }

    public void setTitleText(@StringRes int textRes) {
        this.titleText = this.activity.getString(textRes);
    }

    public void setCancelTextColor(@ColorInt int cancelTextColor) {
        this.cancelTextColor = cancelTextColor;
    }

    public void setSubmitTextColor(@ColorInt int submitTextColor) {
        this.submitTextColor = submitTextColor;
    }

    public void setTitleTextColor(@ColorInt int titleTextColor) {
        this.titleTextColor = titleTextColor;
    }

    @Override
    protected final View makeContentView() {
        LinearLayout rootLayout = new LinearLayout((Context)this.activity);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setBackgroundColor(-1);
        rootLayout.setOrientation(1);
        rootLayout.setGravity(17);
        rootLayout.setPadding(0, 0, 0, 0);
        rootLayout.setClipToPadding(false);
        View headerView = this.makeHeaderView();
        if (headerView != null) {
            rootLayout.addView(headerView);
        }
        if (this.topLineVisible) {
            View lineView = new View((Context)this.activity);
            lineView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 1));
            lineView.setBackgroundColor(this.topLineColor);
            rootLayout.addView(lineView);
        }
        rootLayout.addView(this.makeCenterView(), (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        View footerView = this.makeFooterView();
        if (footerView != null) {
            rootLayout.addView(footerView);
        }
        return rootLayout;
    }

    @Nullable
    protected View makeHeaderView() {
        int margin;
        RelativeLayout topButtonLayout = new RelativeLayout((Context)this.activity);
        topButtonLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, ConvertUtils.toPx((Context)this.activity, 40.0f)));
        topButtonLayout.setBackgroundColor(this.topBackgroundColor);
        topButtonLayout.setGravity(16);
        Button cancelButton = new Button((Context)this.activity);
        cancelButton.setVisibility(this.cancelVisible ? 0 : 8);
        RelativeLayout.LayoutParams cancelButtonLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        cancelButtonLayoutParams.addRule(9, -1);
        cancelButtonLayoutParams.addRule(15, -1);
        cancelButton.setLayoutParams((ViewGroup.LayoutParams)cancelButtonLayoutParams);
        cancelButton.setBackgroundColor(0);
        cancelButton.setGravity(17);
        if (!TextUtils.isEmpty((CharSequence)this.cancelText)) {
            cancelButton.setText(this.cancelText);
        }
        cancelButton.setTextColor(this.cancelTextColor);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConfirmPopup.this.dismiss();
                ConfirmPopup.this.onCancel();
            }
        });
        topButtonLayout.addView((View)cancelButton);
        TextView titleView = new TextView((Context)this.activity);
        RelativeLayout.LayoutParams titleLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        titleLayoutParams.leftMargin = margin = ConvertUtils.toPx((Context)this.activity, 20.0f);
        titleLayoutParams.rightMargin = margin;
        titleLayoutParams.addRule(14, -1);
        titleLayoutParams.addRule(15, -1);
        titleView.setLayoutParams((ViewGroup.LayoutParams)titleLayoutParams);
        titleView.setGravity(17);
        if (!TextUtils.isEmpty((CharSequence)this.titleText)) {
            titleView.setText(this.titleText);
        }
        titleView.setTextColor(this.titleTextColor);
        topButtonLayout.addView((View)titleView);
        Button submitButton = new Button((Context)this.activity);
        RelativeLayout.LayoutParams submitButtonLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        submitButtonLayoutParams.addRule(11, -1);
        submitButtonLayoutParams.addRule(15, -1);
        submitButton.setLayoutParams((ViewGroup.LayoutParams)submitButtonLayoutParams);
        submitButton.setBackgroundColor(0);
        submitButton.setGravity(17);
        if (!TextUtils.isEmpty((CharSequence)this.submitText)) {
            submitButton.setText(this.submitText);
        }
        submitButton.setTextColor(this.submitTextColor);
        submitButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConfirmPopup.this.dismiss();
                ConfirmPopup.this.onSubmit();
            }
        });
        topButtonLayout.addView((View)submitButton);
        return topButtonLayout;
    }

    @NonNull
    protected abstract V makeCenterView();

    @Nullable
    protected View makeFooterView() {
        return null;
    }

    protected void onSubmit() {
    }

    protected void onCancel() {
    }
}

