/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker.core;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.github.gzuliyujiang.calendarpicker.R;
import com.github.gzuliyujiang.calendarpicker.core.CalendarAdapter;
import com.github.gzuliyujiang.calendarpicker.core.ColorScheme;
import com.github.gzuliyujiang.calendarpicker.core.WeekAdapter;

public class CalendarView
extends LinearLayout {
    private final CalendarAdapter calendarAdapter = new CalendarAdapter();
    private final WeekAdapter weekAdapter = new WeekAdapter();
    private final GridView weekView;
    private final RecyclerView bodyView;

    public CalendarView(Context context) {
        this(context, null);
    }

    public CalendarView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CalendarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        CalendarView.inflate((Context)context, (int)R.layout.calendar_body, (ViewGroup)this);
        this.weekView = (GridView)this.findViewById(R.id.calendar_body_week);
        this.weekView.setNumColumns(this.weekAdapter.getCount());
        this.weekView.setAdapter((ListAdapter)this.weekAdapter);
        this.weekView.setSelector((Drawable)new ColorDrawable(0));
        this.bodyView = (RecyclerView)this.findViewById(R.id.calendar_body_content);
        this.bodyView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context, 1, false));
        this.bodyView.setAdapter((RecyclerView.Adapter)this.calendarAdapter);
    }

    public void enablePagerSnap() {
        this.bodyView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
        new PagerSnapHelper().attachToRecyclerView(this.bodyView);
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.weekAdapter.setColorScheme(colorScheme);
        this.calendarAdapter.colorScheme(colorScheme);
    }

    public final GridView getWeekView() {
        return this.weekView;
    }

    public final RecyclerView getBodyView() {
        return this.bodyView;
    }

    public final LinearLayoutManager getLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.bodyView.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            return (LinearLayoutManager)layoutManager;
        }
        throw new IllegalArgumentException("Layout manager must instance of LinearLayoutManager");
    }

    public final CalendarAdapter getAdapter() {
        return this.calendarAdapter;
    }
}

