/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker.core;

import com.github.gzuliyujiang.calendarpicker.core.FestivalProvider;
import com.github.gzuliyujiang.calendarpicker.core.Interval;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class MonthEntity
implements Serializable {
    public static int WEEK_DAYS = 7;
    public static int MAX_HORIZONTAL_LINES = 6;
    public static int MAX_DAYS_OF_MONTH = 31;
    public static String STR_TODAY = "\u4eca\u5929";
    private static final List<MonthEntity> pools = new ArrayList<MonthEntity>();
    private Date date;
    private Interval<Date> valid;
    private Interval<Date> select;
    private Interval<String> note;
    private boolean singleMode = false;
    private FestivalProvider festivalProvider;

    public static MonthEntity obtain(Interval<Date> valid, Interval<Date> select) {
        MonthEntity entity = pools.size() == 0 ? new MonthEntity() : pools.remove(0);
        entity.valid = valid;
        entity.select = select;
        return entity;
    }

    private MonthEntity() {
    }

    public Date date() {
        return this.date;
    }

    public MonthEntity date(Date date) {
        this.date = date;
        return this;
    }

    public Interval<Date> valid() {
        return this.valid;
    }

    public MonthEntity valid(Interval<Date> valid) {
        this.valid = valid;
        return this;
    }

    public Interval<Date> select() {
        return this.select;
    }

    public MonthEntity select(Interval<Date> select) {
        this.select = select;
        return this;
    }

    public MonthEntity singleMode(boolean singleMode) {
        this.singleMode = singleMode;
        return this;
    }

    public boolean singleMode() {
        return this.singleMode;
    }

    public MonthEntity festivalProvider(FestivalProvider festivalProvider) {
        this.festivalProvider = festivalProvider;
        return this;
    }

    public FestivalProvider festivalProvider() {
        return this.festivalProvider;
    }

    public Interval<String> note() {
        return this.note;
    }

    public MonthEntity note(Interval<String> note) {
        this.note = note;
        return this;
    }

    public void recycle() {
        if (!pools.contains(this)) {
            this.date = null;
            this.valid = null;
            this.select = null;
            this.note = null;
            pools.add(this);
        }
    }

    static {
        if (!Locale.getDefault().getDisplayLanguage().contains("\u4e2d\u6587")) {
            STR_TODAY = "Today";
        }
    }
}

