/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker.calendar.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.github.gzuliyujiang.calendarpicker.R;
import com.github.gzuliyujiang.calendarpicker.calendar.protocol.DayEntity;

public final class DayView
extends LinearLayout {
    private TextView tvDesc;
    private TextView tvDay;
    private DayEntity entity;

    public DayView(Context context) {
        super(context);
        this.initialize(context);
    }

    public DayView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    public DayView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.setOrientation(1);
        DayView.inflate((Context)context, (int)R.layout.calendar_day_item, (ViewGroup)this);
        this.setBackgroundColor(-1);
        this.tvDesc = (TextView)this.findViewById(R.id.calendar_day_item_desc);
        this.tvDay = (TextView)this.findViewById(R.id.calendar_day_item_day);
    }

    public void value(DayEntity entity) {
        if (null != this.value()) {
            this.value().recycle();
        }
        this.entity = entity;
        this.tvDay.setText((CharSequence)entity.value());
        this.setTextStatusColor(this.tvDay, entity.valueStatus());
        this.tvDesc.setText((CharSequence)entity.desc());
        this.setTextStatusColor(this.tvDesc, entity.descStatus());
        this.setBackgroundStatus(entity);
    }

    public DayEntity value() {
        return this.entity;
    }

    private void setTextStatusColor(TextView tv, int status) {
        switch (status) {
            case 0: {
                tv.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_day_text_normal_color));
                break;
            }
            case 1: {
                tv.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_day_text_invalid_color));
                break;
            }
            case 2: {
                tv.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_day_text_range_color));
                break;
            }
            case 6: {
                tv.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_day_text_stress_color));
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                tv.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_day_text_select_color));
                break;
            }
        }
    }

    private void setBackgroundStatus(DayEntity entity) {
        switch (entity.status()) {
            case 0: {
                this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_day_background_normal_color));
                this.setEnabled(true);
                break;
            }
            case 1: {
                this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_day_background_invalid_color));
                this.setTextStatusColor(this.tvDay, entity.status());
                this.setEnabled(false);
                break;
            }
            case 2: 
            case 6: {
                this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_day_background_range_color));
                this.setEnabled(true);
                break;
            }
            case 3: {
                this.tvDay.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_day_text_select_color));
                this.tvDesc.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_day_text_select_color));
                this.tvDesc.setText((CharSequence)entity.note());
                this.setBackgroundResource(R.drawable.calendar_shape_day_range_left);
                break;
            }
            case 4: {
                this.tvDay.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_day_text_select_color));
                this.tvDesc.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_day_text_select_color));
                this.tvDesc.setText((CharSequence)entity.note());
                this.setBackgroundResource(R.drawable.calendar_shape_day_range_middle);
                break;
            }
            case 5: {
                this.tvDay.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_day_text_select_color));
                this.tvDesc.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_day_text_select_color));
                this.tvDesc.setText((CharSequence)entity.note());
                this.setBackgroundResource(R.drawable.calendar_shape_day_range_right);
                break;
            }
        }
    }
}

