/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker.calendar.view;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.SimpleAdapter;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.github.gzuliyujiang.calendarpicker.R;
import com.github.gzuliyujiang.calendarpicker.calendar.adapter.CalendarAdapter;
import com.github.gzuliyujiang.calendarpicker.calendar.utils.TimeUtils;
import com.github.gzuliyujiang.calendarpicker.calendar.view.decoration.GroupListener;
import com.github.gzuliyujiang.calendarpicker.calendar.view.decoration.StickyDecoration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class CalendarView
extends LinearLayout {
    private final CalendarAdapter calendarAdapter = new CalendarAdapter();
    private final GridView weekView;
    private final RecyclerView bodyView;
    private final LinearLayoutManager mLayoutManager;

    public CalendarView(Context context) {
        this(context, null);
    }

    public CalendarView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CalendarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        CalendarView.inflate((Context)context, (int)R.layout.calendar_body, (ViewGroup)this);
        this.weekView = (GridView)this.findViewById(R.id.calendar_body_week);
        this.initWeekGridView(context);
        this.bodyView = (RecyclerView)this.findViewById(R.id.calendar_body_content);
        this.mLayoutManager = new LinearLayoutManager(context);
        this.bodyView.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        this.bodyView.setAdapter((RecyclerView.Adapter)this.getAdapter());
        this.initDecoration(this.bodyView);
    }

    private void initWeekGridView(Context context) {
        String[] from = new String[]{"week"};
        int[] to = new int[]{R.id.calendar_week_item_day};
        String[] strings = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
        ArrayList weeks = new ArrayList();
        for (String string : strings) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(from[0], string);
            weeks.add(map);
        }
        SimpleAdapter adapter = new SimpleAdapter(context, weeks, R.layout.calendar_week_item, from, to);
        this.weekView.setNumColumns(adapter.getCount());
        this.weekView.setAdapter((ListAdapter)adapter);
        this.weekView.setSelector((Drawable)new ColorDrawable(0));
    }

    public final GridView getWeekView() {
        return this.weekView;
    }

    public final RecyclerView getBodyView() {
        return this.bodyView;
    }

    public final LinearLayoutManager getLayoutManager() {
        return this.mLayoutManager;
    }

    public final CalendarAdapter getAdapter() {
        return this.calendarAdapter;
    }

    public void initDecoration(RecyclerView bodyView) {
        GroupListener groupListener = new GroupListener(){

            @Override
            public String getGroupName(int position) {
                Date date = CalendarView.this.getAdapter().value(position);
                return TimeUtils.dateText(date.getTime(), "yyyy\u5e74MM\u6708");
            }
        };
        StickyDecoration decoration = StickyDecoration.Builder.init(groupListener).setGroupBackground(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_background_decoration_color)).setGroupHeight((int)this.getResources().getDimension(R.dimen.calendar_decoration_height)).setDivideColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_month_divide_line_color)).setDivideHeight((int)this.getResources().getDimension(R.dimen.calendar_decoration_divide_line_height)).setGroupTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.calendar_text_decoration_color)).setTypeface(Typeface.defaultFromStyle((int)1)).setGroupTextSize((int)this.getResources().getDimension(R.dimen.calendar_decoration_text_size)).setTextSideMargin((int)(10.0f * this.getResources().getDisplayMetrics().density + 0.5f)).setTextAlign(Paint.Align.CENTER).build();
        bodyView.addItemDecoration((RecyclerView.ItemDecoration)decoration);
    }
}

