/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker.calendar.utils;

import com.github.gzuliyujiang.calendarpicker.calendar.protocol.Interval;
import com.github.gzuliyujiang.calendarpicker.calendar.protocol.NInterval;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DateUtils {
    public static Calendar calendar(long timeInMillis) {
        return DateUtils.calendar(new Date(timeInMillis));
    }

    public static Calendar calendar(Date date) {
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setTime(date);
        return calendar;
    }

    public static int maxDaysOfMonth(Date date) {
        return DateUtils.calendar(date).getActualMaximum(5);
    }

    public static int firstDayOfMonthIndex(Date date) {
        Calendar calendar = DateUtils.calendar(date);
        calendar.set(5, 1);
        return calendar.get(7) - 1;
    }

    public static int isTodayOfMonth(Date date) {
        Calendar calendar;
        Calendar current = DateUtils.calendar(new Date());
        if (DateUtils.diverse(current, calendar = DateUtils.calendar(date), 1)) {
            return -1;
        }
        if (DateUtils.diverse(current, calendar, 2)) {
            return -1;
        }
        return current.get(5) - 1;
    }

    public static boolean diverse(Calendar calendarA, Calendar calendarB, int field) {
        boolean same;
        try {
            same = calendarA.get(field) == calendarB.get(field);
        }
        catch (Exception e) {
            same = false;
        }
        return !same;
    }

    public static int months(Date sDate, Date eDate) {
        Calendar before = DateUtils.calendar(DateUtils.min(sDate, eDate));
        Calendar after = DateUtils.calendar(DateUtils.max(sDate, eDate));
        int diffYear = after.get(1) - before.get(1);
        int diffMonth = after.get(2) - before.get(2);
        return diffYear * 12 + diffMonth;
    }

    public static Date max(Date sDate, Date eDate) {
        return sDate.getTime() > eDate.getTime() ? sDate : eDate;
    }

    public static Date min(Date sDate, Date eDate) {
        return sDate.getTime() > eDate.getTime() ? eDate : sDate;
    }

    public static List<Date> fillMonths(Date sDate, Date eDate) {
        ArrayList<Date> dates = new ArrayList<Date>();
        if (null == sDate || null == eDate) {
            dates.add(new Date());
        } else {
            Calendar calendar = DateUtils.calendar(DateUtils.min(sDate, eDate));
            int months = DateUtils.months(sDate, eDate);
            for (int i = 0; i <= months; ++i) {
                dates.add(calendar.getTime());
                calendar.add(2, 1);
            }
        }
        return dates;
    }

    public static NInterval daysInterval(Date month, Interval<Date> dateInterval) {
        Date eDay;
        Date sDay;
        NInterval range = new NInterval();
        if (null == month || null == dateInterval) {
            return range;
        }
        int maxDaysOfMonth = DateUtils.maxDaysOfMonth(month);
        if (null == dateInterval.left()) {
            Calendar safeCalendar = DateUtils.calendar(month);
            safeCalendar.set(5, 1);
            sDay = safeCalendar.getTime();
        } else {
            sDay = new Date(dateInterval.left().getTime());
        }
        if (null == dateInterval.right()) {
            Date date = DateUtils.max(sDay, month);
            Calendar safeCalendar = DateUtils.calendar(date);
            safeCalendar.set(5, maxDaysOfMonth);
            eDay = safeCalendar.getTime();
        } else {
            eDay = new Date(dateInterval.right().getTime());
        }
        sDay = DateUtils.min(sDay, eDay);
        eDay = DateUtils.max(sDay, eDay);
        Calendar[] calendars = new Calendar[]{DateUtils.calendar(month), DateUtils.calendar(sDay), DateUtils.calendar(eDay)};
        Calendar miniYearCalendar = calendars[0];
        for (int i = 1; i < calendars.length; ++i) {
            if (miniYearCalendar.get(1) <= calendars[i].get(1)) continue;
            miniYearCalendar = calendars[i];
        }
        long miniDate = miniYearCalendar.getTime().getTime();
        long[] diffDays = new long[calendars.length];
        for (int i = 0; i < calendars.length; ++i) {
            Calendar cal = DateUtils.calendar(new Date(miniDate));
            int diffYear = calendars[i].get(1) - cal.get(1);
            for (int j = 0; j < diffYear; ++j) {
                int n = i;
                diffDays[n] = diffDays[n] + (long)cal.getActualMaximum(6);
                cal.add(1, 1);
            }
        }
        calendars[0].set(5, 1);
        long dayIndex = diffDays[0] + (long)calendars[0].get(6);
        long limitA = diffDays[1] + (long)calendars[1].get(6);
        long limitB = diffDays[2] + (long)calendars[2].get(6);
        for (int i = 0; i < maxDaysOfMonth; ++i) {
            boolean contain;
            long temp = dayIndex + (long)i;
            boolean bl = contain = temp >= limitA && temp <= limitB;
            if (!contain) continue;
            if ((Integer)range.left() < 0) {
                range.left(i);
            }
            range.right(i);
            if (limitA == temp) {
                range.lBound(i);
            }
            if (limitB != temp) continue;
            range.rBound(i);
        }
        return range;
    }

    public static Date specialDayInMonth(Date month, int index) {
        Calendar calendar = DateUtils.calendar(month);
        calendar.set(5, index + 1);
        return calendar.getTime();
    }

    public static Date getLastDayFromMonth(Date date) {
        Calendar calendar = DateUtils.calendar(date);
        calendar.set(5, DateUtils.maxDaysOfMonth(date));
        return calendar.getTime();
    }

    public static Date getDayYearAgo(Date date) {
        Calendar calendar = DateUtils.calendar(date);
        calendar.add(2, -11);
        calendar.set(5, 0);
        return calendar.getTime();
    }
}

