/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.calendarpicker.calendar.adapter;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.github.gzuliyujiang.calendarpicker.calendar.adapter.CalendarViewHolder;
import com.github.gzuliyujiang.calendarpicker.calendar.protocol.Interval;
import com.github.gzuliyujiang.calendarpicker.calendar.protocol.MonthEntity;
import com.github.gzuliyujiang.calendarpicker.calendar.protocol.OnCalendarSelectListener;
import com.github.gzuliyujiang.calendarpicker.calendar.protocol.OnMonthClickListener;
import com.github.gzuliyujiang.calendarpicker.calendar.utils.DateUtils;
import com.github.gzuliyujiang.calendarpicker.calendar.utils.TimeUtils;
import com.github.gzuliyujiang.calendarpicker.calendar.view.MonthView;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class CalendarAdapter
extends RecyclerView.Adapter<CalendarViewHolder>
implements OnMonthClickListener {
    private final String TAG = CalendarAdapter.class.getSimpleName();
    private final List<Date> dates = new ArrayList<Date>();
    private Interval<Date> valid = new Interval();
    private Interval<Date> select = new Interval();
    private Interval<String> selectNote = new Interval();
    private boolean singleFlag = false;
    private Date lastClickDate = null;
    private OnCalendarSelectListener calendarSelectListener;

    public void setRange(Date sDate, Date eDate, boolean clean, boolean notify) {
        List<Date> dates = DateUtils.fillMonths(sDate, eDate);
        this.setRange(dates, clean, notify);
    }

    public void setRange(String sTime, String eTime, String format, boolean clean, boolean notify) {
        Date[] dates = new Date[2];
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.SIMPLIFIED_CHINESE);
            dates[0] = sdf.parse(sTime);
            dates[1] = sdf.parse(eTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setRange(dates[0], dates[1], clean, notify);
    }

    public void setRange(List<Date> list, boolean clean, boolean notify) {
        if (clean) {
            this.dates.clear();
        }
        if (null != list && list.size() > 0) {
            this.dates.addAll(list);
        }
        if (notify) {
            this.notifyDataSetChanged();
        }
    }

    public void single(boolean value) {
        this.singleFlag = value;
    }

    public void valid(String fromDay, String toDay) {
        try {
            Date from = TimeUtils.date(fromDay, "yyyy-MM-dd");
            this.valid.left(from);
        }
        catch (Exception e) {
            this.valid.left(null);
        }
        try {
            Date to = TimeUtils.date(toDay, "yyyy-MM-dd");
            this.valid.right(to);
        }
        catch (Exception e) {
            this.valid.right(null);
        }
        this.notifyDataSetChanged();
    }

    public void valid(Date from, Date to) {
        this.valid.left(from);
        this.valid.right(to);
        this.notifyDataSetChanged();
    }

    public void intervalNotes(String noteFrom, String noteTo) {
        this.selectNote.left(noteFrom);
        this.selectNote.right(noteTo);
    }

    public void select(String fromDay, String toDay) {
        try {
            Date from = TimeUtils.date(fromDay, "yyyy-MM-dd");
            Date to = TimeUtils.date(toDay, "yyyy-MM-dd");
            this.select(from, to);
        }
        catch (Exception e) {
            this.select.left(null);
            this.select.right(null);
            this.notifyDataSetChanged();
        }
    }

    public void select(Date from, Date to) {
        this.select.left(from);
        this.select.right(to);
        this.notifyDataSetChanged();
    }

    @NonNull
    public CalendarViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        MonthView view = new MonthView(parent.getContext());
        int width = -1;
        int height = -2;
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(width, height);
        view.setLayoutParams(params);
        view.setOnDayInMonthClickListener(this);
        return new CalendarViewHolder((View)view);
    }

    public void onBindViewHolder(@NonNull CalendarViewHolder holder, int position) {
        MonthEntity entity = MonthEntity.obtain(this.valid, this.select).date(this.dates.get(position)).singleFlag(this.singleFlag).selectNote(this.selectNote);
        holder.view().value(entity);
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
    }

    public int getItemCount() {
        return this.dates.size();
    }

    public int getDatePosition(Date date) {
        int position = -1;
        if (this.dates.size() > 1) {
            if (date.getTime() <= this.dates.get(0).getTime()) {
                position = 0;
            } else if (date.getTime() >= this.dates.get(this.dates.size() - 1).getTime()) {
                position = this.dates.size() - 1;
            } else {
                for (int i = 0; i < this.dates.size() - 1; ++i) {
                    if (date.getTime() < this.dates.get(i).getTime() || date.getTime() > this.dates.get(i + 1).getTime()) continue;
                    position = i;
                    break;
                }
            }
        }
        return position;
    }

    public Date value(int position) {
        if (position >= 0 && position < this.dates.size()) {
            return this.dates.get(position);
        }
        return new Date(0L);
    }

    public void setOnCalendarSelectListener(OnCalendarSelectListener listener) {
        this.calendarSelectListener = listener;
    }

    @Override
    public void onMonthClick(Date date) {
        if (null == this.calendarSelectListener) {
            return;
        }
        if (null == date) {
            Log.d((String)this.TAG, (String)"onDayInMonthClick error,receive null date");
            return;
        }
        if (null == this.lastClickDate || this.singleFlag) {
            this.lastClickDate = date;
            this.select(date, date);
            this.calendarSelectListener.onSingleSelect(date);
            return;
        }
        if (this.lastClickDate.getTime() >= date.getTime()) {
            this.lastClickDate = date;
            this.select(date, date);
            this.calendarSelectListener.onSingleSelect(date);
        } else {
            this.select(this.lastClickDate, date);
            this.calendarSelectListener.onDoubleSelect(this.lastClickDate, date);
            Log.d((String)this.TAG, (String)("onDayInMonthClick:" + this.lastClickDate.getTime() + "," + date.getTime()));
            this.lastClickDate = null;
        }
    }
}

