/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.dialog.DialogLog;
import com.github.gzuliyujiang.wheelpicker.LinkagePicker;
import com.github.gzuliyujiang.wheelpicker.contract.AddressLoader;
import com.github.gzuliyujiang.wheelpicker.contract.AddressParser;
import com.github.gzuliyujiang.wheelpicker.contract.AddressReceiver;
import com.github.gzuliyujiang.wheelpicker.contract.LinkageProvider;
import com.github.gzuliyujiang.wheelpicker.contract.OnAddressLoadListener;
import com.github.gzuliyujiang.wheelpicker.contract.OnAddressPickedListener;
import com.github.gzuliyujiang.wheelpicker.contract.OnLinkagePickedListener;
import com.github.gzuliyujiang.wheelpicker.entity.CityEntity;
import com.github.gzuliyujiang.wheelpicker.entity.CountyEntity;
import com.github.gzuliyujiang.wheelpicker.entity.ProvinceEntity;
import com.github.gzuliyujiang.wheelpicker.impl.AddressProvider;
import com.github.gzuliyujiang.wheelpicker.impl.AssetAddressLoader;
import com.github.gzuliyujiang.wheelpicker.utility.AddressJsonParser;
import com.github.gzuliyujiang.wheelview.widget.WheelView;
import java.util.List;

public class AddressPicker
extends LinkagePicker
implements AddressReceiver {
    private AddressLoader addressLoader;
    private AddressParser addressParser;
    private int addressMode;
    private OnAddressPickedListener onAddressPickedListener;
    private OnAddressLoadListener onAddressLoadListener;

    public AddressPicker(@NonNull Activity activity) {
        super(activity);
    }

    public AddressPicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    protected void initData() {
        super.initData();
        if (this.addressLoader == null || this.addressParser == null) {
            return;
        }
        this.wheelLayout.showLoading();
        if (this.onAddressLoadListener != null) {
            this.onAddressLoadListener.onAddressLoadStarted();
        }
        DialogLog.print((Object)"Address data loading");
        this.addressLoader.loadJson(this, this.addressParser);
    }

    @Override
    public void onAddressReceived(@NonNull List<ProvinceEntity> data) {
        DialogLog.print((Object)"Address data received");
        this.wheelLayout.hideLoading();
        if (this.onAddressLoadListener != null) {
            this.onAddressLoadListener.onAddressLoadFinished(data);
        }
        this.wheelLayout.setData((LinkageProvider)new AddressProvider(data, this.addressMode));
    }

    @Deprecated
    public void setData(@NonNull LinkageProvider data) {
        throw new UnsupportedOperationException("Use setAddressMode or setAddressLoader instead");
    }

    @Deprecated
    public void setOnLinkagePickedListener(OnLinkagePickedListener onLinkagePickedListener) {
        throw new UnsupportedOperationException("Use setOnAddressPickedListener instead");
    }

    protected void onOk() {
        if (this.onAddressPickedListener != null) {
            ProvinceEntity province = (ProvinceEntity)this.wheelLayout.getFirstWheelView().getCurrentItem();
            CityEntity city = (CityEntity)this.wheelLayout.getSecondWheelView().getCurrentItem();
            CountyEntity county = (CountyEntity)this.wheelLayout.getThirdWheelView().getCurrentItem();
            this.onAddressPickedListener.onAddressPicked(province, city, county);
        }
    }

    public void setOnAddressPickedListener(@NonNull OnAddressPickedListener onAddressPickedListener) {
        this.onAddressPickedListener = onAddressPickedListener;
    }

    public void setOnAddressLoadListener(@NonNull OnAddressLoadListener onAddressLoadListener) {
        this.onAddressLoadListener = onAddressLoadListener;
    }

    public void setAddressLoader(@NonNull AddressLoader loader, @NonNull AddressParser parser) {
        this.addressLoader = loader;
        this.addressParser = parser;
    }

    public void setAddressMode(int addressMode) {
        this.setAddressMode("china_address.json", addressMode);
    }

    public void setAddressMode(@NonNull String assetPath, int addressMode) {
        this.setAddressMode(assetPath, addressMode, new AddressJsonParser());
    }

    public void setAddressMode(@NonNull String assetPath, int addressMode, @NonNull AddressJsonParser jsonParser) {
        this.addressMode = addressMode;
        this.setAddressLoader(new AssetAddressLoader(this.getContext(), assetPath), jsonParser);
    }

    public final WheelView getProvinceWheelView() {
        return this.wheelLayout.getFirstWheelView();
    }

    public final WheelView getCityWheelView() {
        return this.wheelLayout.getSecondWheelView();
    }

    public final WheelView getCountyWheelView() {
        return this.wheelLayout.getThirdWheelView();
    }

    public final TextView getProvinceLabelView() {
        return this.wheelLayout.getFirstLabelView();
    }

    public final TextView getCityLabelView() {
        return this.wheelLayout.getSecondLabelView();
    }

    public final TextView getCountyLabelView() {
        return this.wheelLayout.getThirdLabelView();
    }
}

