/*
 * Decompiled with CFR 0.152.
 */
package com.github.gv2011.m2t.imp;

import com.github.gv2011.m2t.ArtifactRef;
import com.github.gv2011.m2t.M2t;
import com.github.gv2011.m2t.Scope;
import com.github.gv2011.util.CollectionUtils;
import com.github.gv2011.util.FileUtils;
import com.github.gv2011.util.StreamUtils;
import com.github.gv2011.util.StringUtils;
import com.github.gv2011.util.Verify;
import com.github.gv2011.util.ex.Exceptions;
import com.github.gv2011.util.icol.ICollections;
import com.github.gv2011.util.icol.ISortedSet;
import com.github.gv2011.util.icol.Opt;
import com.github.gv2011.util.lock.Lock;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class M2tImp
implements M2t {
    private static final Logger LOG = LoggerFactory.getLogger(M2tImp.class);
    private static final String POM_TEMPLATE = StreamUtils.readText(() -> (InputStream)Verify.notNull((Object)M2tImp.class.getResourceAsStream("pom-template.txt")));
    private final Lock lock = Lock.create();
    private final Map<ArtifactRef, Path> cache = new HashMap<ArtifactRef, Path>();

    M2tImp() {
    }

    public static void main(String[] args) {
        System.out.println(M2tImp.class.getResource("pom-template.xml"));
    }

    public Path resolve(ArtifactRef artifact) {
        return (Path)((Opt)this.lock.apply((Object)artifact, a -> CollectionUtils.tryGet(this.cache, (Object)artifact))).orElseGet(() -> {
            Path dir = this.createTmpDirectoryWithFakePom(artifact);
            DefaultInvocationRequest listDependency = new DefaultInvocationRequest();
            listDependency.setBaseDirectory(dir.toFile());
            listDependency.setGoals((List)ICollections.listOf((Object)"dependency:list"));
            Properties properties = new Properties();
            properties.setProperty("excludeTransitive", Boolean.toString(true));
            properties.setProperty("outputAbsoluteArtifactFilename", Boolean.toString(true));
            Path out = dir.resolve("out.txt");
            properties.setProperty("outputFile", out.toString());
            listDependency.setProperties(properties);
            this.execute((InvocationRequest)listDependency);
            String classifier = artifact.classifier().isEmpty() ? "" : Exceptions.format((String)":{}", (Object[])new Object[]{artifact.classifier()});
            String prefix = Exceptions.format((String)"{}:{}:{}{}:{}:", (Object[])new Object[]{artifact.groupId(), artifact.artifactId(), artifact.type(), classifier, artifact.version()});
            String line = (String)FileUtils.readText((Path)out).lines().map(String::trim).filter(l -> {
                boolean found = l.startsWith(prefix);
                LOG.trace("Match: {}. Prefix: {}, line: {}.", new Object[]{found, prefix, l});
                return found;
            }).map(l -> StringUtils.removePrefix((String)l, (String)prefix)).collect(CollectionUtils.toSingle());
            String fileStr = line.startsWith("compile:") ? StringUtils.removePrefix((String)line, (String)"compile:") : StringUtils.removePrefix((String)line, (String)"runtime:");
            Path result = Paths.get(fileStr, new String[0]);
            Verify.verify((boolean)Files.isRegularFile(result, new LinkOption[0]));
            FileUtils.deleteFile((Path)out);
            FileUtils.deleteFile((Path)dir.resolve("pom.xml"));
            Exceptions.call(() -> dir.toFile().delete());
            this.lock.run(() -> this.cache.put(artifact, result));
            return result;
        });
    }

    public ISortedSet<Path> getClasspath(ArtifactRef artifact, Scope scope) {
        Path dir = this.createTmpDirectoryWithFakePom(artifact);
        DefaultInvocationRequest buildClasspath = new DefaultInvocationRequest();
        buildClasspath.setBaseDirectory(dir.toFile());
        buildClasspath.setGoals((List)ICollections.listOf((Object)"dependency:build-classpath"));
        String classpathFileName = "classpath.txt";
        Path out = dir.resolve("classpath.txt");
        char pathSeparatorChar = File.pathSeparatorChar;
        Properties properties = new Properties();
        properties.setProperty("includeScope", scope.toString());
        properties.setProperty("mdep.fileSeparator", Character.toString(File.separatorChar));
        properties.setProperty("mdep.pathSeparator", Character.toString(pathSeparatorChar));
        properties.setProperty("outputAbsoluteArtifactFilename", Boolean.toString(true));
        properties.setProperty("mdep.outputFile", "classpath.txt");
        buildClasspath.setProperties(properties);
        this.execute((InvocationRequest)buildClasspath);
        ISortedSet result = (ISortedSet)StringUtils.split((String)FileUtils.readText((Path)out), (char)pathSeparatorChar).stream().map(f -> Paths.get(f, new String[0])).map(Verify.verifier(p -> Files.isRegularFile(p, new LinkOption[0]))).collect(ICollections.toISortedSet());
        FileUtils.deleteFile((Path)out);
        FileUtils.deleteFile((Path)dir.resolve("pom.xml"));
        Exceptions.call(() -> dir.toFile().delete());
        return result;
    }

    public Path copy(ArtifactRef artifact, Path directory) {
        Path dir = (Path)Exceptions.call(() -> directory.toRealPath(new LinkOption[0]));
        Verify.verify((boolean)Files.isDirectory(dir, new LinkOption[0]));
        DefaultInvocationRequest copyToTmpDir = new DefaultInvocationRequest();
        copyToTmpDir.setGoals((List)ICollections.listOf((Object)"dependency:copy"));
        Properties properties = new Properties();
        properties.setProperty("artifact", Exceptions.format((String)"{}:{}:{}:{}:{}", (Object[])new Object[]{artifact.groupId(), artifact.artifactId(), artifact.version(), artifact.type(), artifact.classifier()}));
        properties.setProperty("outputDirectory", dir.toString());
        properties.setProperty("interactiveMode", Boolean.toString(false));
        copyToTmpDir.setProperties(properties);
        AtomicReference<String> fileName = new AtomicReference<String>("");
        String prefix = "[INFO] Copying ";
        this.execute((InvocationRequest)copyToTmpDir, line -> {
            if (line.startsWith("[INFO] Copying ")) {
                Verify.verify((boolean)fileName.compareAndSet("", (String)StringUtils.split((String)StringUtils.removePrefix((String)line, (String)"[INFO] Copying "), (char)' ').first()));
            }
        });
        Verify.verify((Object)fileName.get(), f -> !f.isBlank());
        Path result = dir.resolve(fileName.get());
        Verify.verify((Object)result, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
        return result;
    }

    public void close() {
    }

    private void execute(InvocationRequest request) {
        this.execute(request, s -> {});
    }

    private void execute(InvocationRequest request, Consumer<String> outListener) {
        request.setBatchMode(true);
        DefaultInvoker invoker = new DefaultInvoker();
        AtomicBoolean producedErrorLines = new AtomicBoolean();
        invoker.setErrorHandler(errorLine -> {
            producedErrorLines.set(true);
            LOG.error("Maven Error: {}", (Object)errorLine);
        });
        invoker.setOutputHandler(line -> {
            LOG.debug("Maven out: {}", (Object)line);
            outListener.accept(line);
        });
        InvocationResult result = (InvocationResult)Exceptions.call(() -> M2tImp.lambda$execute$17((Invoker)invoker, request));
        Opt.ofNullable((Object)result.getExecutionException()).ifPresent(ex -> {
            throw Exceptions.wrap((Throwable)ex);
        });
        Verify.verifyEqual((Object)result.getExitCode(), (Object)0);
        Verify.verifyEqual((Object)producedErrorLines.get(), (Object)false);
    }

    private Path createTmpDirectoryWithFakePom(ArtifactRef artifact) {
        Path dir = (Path)Exceptions.call(() -> Files.createTempDirectory(M2tImp.class.getSimpleName(), new FileAttribute[0]).toRealPath(new LinkOption[0]));
        Path pom = dir.resolve("pom.xml");
        String classifier = artifact.classifier().isEmpty() ? "" : Exceptions.format((String)"\n      <classifier>{}</classifier>", (Object[])new Object[]{artifact.classifier()});
        FileUtils.writeText((String)Exceptions.format((String)POM_TEMPLATE, (Object[])new Object[]{artifact.groupId(), artifact.artifactId(), artifact.version(), artifact.type(), classifier}), (Path)pom);
        LOG.debug("Created fake pom at {}.", (Object)pom);
        return dir;
    }

    private static /* synthetic */ InvocationResult lambda$execute$17(Invoker invoker, InvocationRequest request) throws Exception {
        return invoker.execute(request);
    }
}

