/*
 * Decompiled with CFR 0.152.
 */
package com.guoxiaoxing.phoenix.core;

import android.app.Activity;
import android.graphics.Color;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import com.guoxiaoxing.phoenix.core.listener.Starter;
import com.guoxiaoxing.phoenix.core.model.MediaEntity;
import com.guoxiaoxing.phoenix.core.model.MimeType;
import com.guoxiaoxing.phoenix.core.util.ReflectUtils;
import java.util.ArrayList;
import java.util.List;

public class PhoenixOption
implements Parcelable {
    public static final int TYPE_PICK_MEDIA = 1;
    public static final int TYPE_TAKE_PICTURE = 2;
    public static final int TYPE_BROWSER_PICTURE = 3;
    public static final int THEME_DEFAULT = Color.parseColor((String)"#333333");
    public static final int THEME_RED = Color.parseColor((String)"#FF4040");
    public static final int THEME_ORANGE = Color.parseColor((String)"#FF571A");
    public static final int THEME_BLUE = Color.parseColor((String)"#538EEB");
    private int fileType = MimeType.ofImage();
    private boolean enableCamera = false;
    private int theme = THEME_DEFAULT;
    private int maxPickNumber = 0;
    private int minPickNumber = 0;
    private int videoFilterTime;
    private int recordVideoTime = 60;
    private int spanCount = 4;
    private int thumbnailWidth = 160;
    private int thumbnailHeight = 160;
    private boolean enableAnimation = true;
    private boolean enableGif;
    private boolean enablePreview = true;
    private boolean pickNumberMode;
    private boolean enableClickSound = true;
    private boolean previewEggs = true;
    private boolean enableCompress;
    private int compressVideoFilterSize = 2048;
    private int compressPictureFilterSize = 1024;
    private List<MediaEntity> pickedMediaList = new ArrayList<MediaEntity>();
    private String savePath = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath();
    public static final Parcelable.Creator<PhoenixOption> CREATOR = new Parcelable.Creator<PhoenixOption>(){

        public PhoenixOption createFromParcel(Parcel source) {
            return new PhoenixOption(source);
        }

        public PhoenixOption[] newArray(int size) {
            return new PhoenixOption[size];
        }
    };

    public PhoenixOption() {
    }

    public int getFileType() {
        return this.fileType;
    }

    public boolean isEnableCamera() {
        return this.enableCamera;
    }

    public boolean isEnableGif() {
        return this.enableGif;
    }

    public boolean isEnablePreview() {
        return this.enablePreview;
    }

    public boolean isPickNumberMode() {
        return this.pickNumberMode;
    }

    public boolean isEnableClickSound() {
        return this.enableClickSound;
    }

    public boolean isPreviewEggs() {
        return this.previewEggs;
    }

    public List<MediaEntity> getPickedMediaList() {
        return this.pickedMediaList;
    }

    public boolean isEnableCompress() {
        return this.enableCompress;
    }

    public int getCompressVideoFilterSize() {
        return this.compressVideoFilterSize;
    }

    public int getCompressPictureFilterSize() {
        return this.compressPictureFilterSize;
    }

    public String getSavePath() {
        return this.savePath;
    }

    public int getTheme() {
        return this.theme;
    }

    public int getMaxPickNumber() {
        return this.maxPickNumber;
    }

    public int getMinPickNumber() {
        return this.minPickNumber;
    }

    public int getVideoFilterTime() {
        return this.videoFilterTime;
    }

    public int getRecordVideoTime() {
        return this.recordVideoTime;
    }

    public int getSpanCount() {
        return this.spanCount;
    }

    public int getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public int getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public boolean isEnableAnimation() {
        return this.enableAnimation;
    }

    public PhoenixOption fileType(int val) {
        this.fileType = val;
        return this;
    }

    public PhoenixOption enableCamera(boolean val) {
        this.enableCamera = val;
        return this;
    }

    public PhoenixOption theme(int val) {
        this.theme = val;
        return this;
    }

    public PhoenixOption maxPickNumber(int val) {
        this.maxPickNumber = val;
        return this;
    }

    public PhoenixOption minPickNumber(int val) {
        this.minPickNumber = val;
        return this;
    }

    public PhoenixOption videoFilterTime(int val) {
        this.videoFilterTime = val;
        return this;
    }

    public PhoenixOption recordVideoTime(int val) {
        this.recordVideoTime = val;
        return this;
    }

    public PhoenixOption spanCount(int val) {
        this.spanCount = val;
        return this;
    }

    public PhoenixOption thumbnailWidth(int val) {
        this.thumbnailWidth = val;
        return this;
    }

    public PhoenixOption thumbnailHeight(int val) {
        this.thumbnailHeight = val;
        return this;
    }

    public PhoenixOption enableAnimation(boolean val) {
        this.enableAnimation = val;
        return this;
    }

    public PhoenixOption enableGif(boolean val) {
        this.enableGif = val;
        return this;
    }

    public PhoenixOption enablePreview(boolean val) {
        this.enablePreview = val;
        return this;
    }

    public PhoenixOption pickNumberMode(boolean val) {
        this.pickNumberMode = val;
        return this;
    }

    public PhoenixOption enableClickSound(boolean val) {
        this.enableClickSound = val;
        return this;
    }

    public PhoenixOption previewEggs(boolean val) {
        this.previewEggs = val;
        return this;
    }

    public PhoenixOption pickedMediaList(List<MediaEntity> val) {
        this.pickedMediaList = val;
        return this;
    }

    public PhoenixOption enableCompress(boolean val) {
        this.enableCompress = val;
        return this;
    }

    public PhoenixOption compressVideoFilterSize(int val) {
        this.compressVideoFilterSize = val;
        return this;
    }

    public PhoenixOption compressPictureFilterSize(int val) {
        this.compressPictureFilterSize = val;
        return this;
    }

    public PhoenixOption savePath(String val) {
        this.savePath = val;
        return this;
    }

    public void start(Activity activity, int type, int requestCode) {
        Starter starter = ReflectUtils.loadStarter("com.guoxiaoxing.phoenix.picker.Phoenix");
        if (starter != null) {
            starter.start(activity, this, type, requestCode);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.fileType);
        dest.writeByte(this.enableCamera ? (byte)1 : 0);
        dest.writeInt(this.theme);
        dest.writeInt(this.maxPickNumber);
        dest.writeInt(this.minPickNumber);
        dest.writeInt(this.videoFilterTime);
        dest.writeInt(this.recordVideoTime);
        dest.writeInt(this.spanCount);
        dest.writeInt(this.thumbnailWidth);
        dest.writeInt(this.thumbnailHeight);
        dest.writeByte(this.enableAnimation ? (byte)1 : 0);
        dest.writeByte(this.enableGif ? (byte)1 : 0);
        dest.writeByte(this.enablePreview ? (byte)1 : 0);
        dest.writeByte(this.pickNumberMode ? (byte)1 : 0);
        dest.writeByte(this.enableClickSound ? (byte)1 : 0);
        dest.writeByte(this.previewEggs ? (byte)1 : 0);
        dest.writeByte(this.enableCompress ? (byte)1 : 0);
        dest.writeInt(this.compressVideoFilterSize);
        dest.writeInt(this.compressPictureFilterSize);
        dest.writeTypedList(this.pickedMediaList);
        dest.writeString(this.savePath);
    }

    protected PhoenixOption(Parcel in) {
        this.fileType = in.readInt();
        this.enableCamera = in.readByte() != 0;
        this.theme = in.readInt();
        this.maxPickNumber = in.readInt();
        this.minPickNumber = in.readInt();
        this.videoFilterTime = in.readInt();
        this.recordVideoTime = in.readInt();
        this.spanCount = in.readInt();
        this.thumbnailWidth = in.readInt();
        this.thumbnailHeight = in.readInt();
        this.enableAnimation = in.readByte() != 0;
        this.enableGif = in.readByte() != 0;
        this.enablePreview = in.readByte() != 0;
        this.pickNumberMode = in.readByte() != 0;
        this.enableClickSound = in.readByte() != 0;
        this.previewEggs = in.readByte() != 0;
        this.enableCompress = in.readByte() != 0;
        this.compressVideoFilterSize = in.readInt();
        this.compressPictureFilterSize = in.readInt();
        this.pickedMediaList = in.createTypedArrayList(MediaEntity.CREATOR);
        this.savePath = in.readString();
    }
}

