/*
 * Decompiled with CFR 0.152.
 */
package com.guoxiaoxing.phoenix.compress.video.engine;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import com.guoxiaoxing.phoenix.compress.video.engine.InputSurface;
import com.guoxiaoxing.phoenix.compress.video.engine.OutputSurface;
import com.guoxiaoxing.phoenix.compress.video.engine.QueuedMuxer;
import com.guoxiaoxing.phoenix.compress.video.engine.TrackTranscoder;
import java.io.IOException;
import java.nio.ByteBuffer;

public class VideoTrackTranscoder
implements TrackTranscoder {
    private static final String TAG = "VideoTrackTranscoder";
    private static final int DRAIN_STATE_NONE = 0;
    private static final int DRAIN_STATE_SHOULD_RETRY_IMMEDIATELY = 1;
    private static final int DRAIN_STATE_CONSUMED = 2;
    private final MediaExtractor mExtractor;
    private final int mTrackIndex;
    private final MediaFormat mOutputFormat;
    private final QueuedMuxer mMuxer;
    private final MediaCodec.BufferInfo mBufferInfo = new MediaCodec.BufferInfo();
    private MediaCodec mDecoder;
    private MediaCodec mEncoder;
    private ByteBuffer[] mDecoderInputBuffers;
    private ByteBuffer[] mEncoderOutputBuffers;
    private MediaFormat mActualOutputFormat;
    private OutputSurface mDecoderOutputSurfaceWrapper;
    private InputSurface mEncoderInputSurfaceWrapper;
    private boolean mIsExtractorEOS;
    private boolean mIsDecoderEOS;
    private boolean mIsEncoderEOS;
    private boolean mDecoderStarted;
    private boolean mEncoderStarted;
    private long mWrittenPresentationTimeUs;

    public VideoTrackTranscoder(MediaExtractor extractor, int trackIndex, MediaFormat outputFormat, QueuedMuxer muxer) {
        this.mExtractor = extractor;
        this.mTrackIndex = trackIndex;
        this.mOutputFormat = outputFormat;
        this.mMuxer = muxer;
    }

    @Override
    public void setup() {
        this.mExtractor.selectTrack(this.mTrackIndex);
        try {
            this.mEncoder = MediaCodec.createEncoderByType((String)this.mOutputFormat.getString("mime"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.mEncoder.configure(this.mOutputFormat, null, null, 1);
        this.mEncoderInputSurfaceWrapper = new InputSurface(this.mEncoder.createInputSurface());
        this.mEncoderInputSurfaceWrapper.makeCurrent();
        this.mEncoder.start();
        this.mEncoderStarted = true;
        this.mEncoderOutputBuffers = this.mEncoder.getOutputBuffers();
        MediaFormat inputFormat = this.mExtractor.getTrackFormat(this.mTrackIndex);
        if (inputFormat.containsKey("rotation-degrees")) {
            inputFormat.setInteger("rotation-degrees", 0);
        }
        this.mDecoderOutputSurfaceWrapper = new OutputSurface();
        try {
            this.mDecoder = MediaCodec.createDecoderByType((String)inputFormat.getString("mime"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.mDecoder.configure(inputFormat, this.mDecoderOutputSurfaceWrapper.getSurface(), null, 0);
        this.mDecoder.start();
        this.mDecoderStarted = true;
        this.mDecoderInputBuffers = this.mDecoder.getInputBuffers();
    }

    @Override
    public MediaFormat getDeterminedFormat() {
        return this.mActualOutputFormat;
    }

    @Override
    public boolean stepPipeline() {
        int status;
        boolean busy = false;
        while (this.drainEncoder(0L) != 0) {
            busy = true;
        }
        do {
            if ((status = this.drainDecoder(0L)) == 0) continue;
            busy = true;
        } while (status == 1);
        while (this.drainExtractor(0L) != 0) {
            busy = true;
        }
        return busy;
    }

    @Override
    public long getWrittenPresentationTimeUs() {
        return this.mWrittenPresentationTimeUs;
    }

    @Override
    public boolean isFinished() {
        return this.mIsEncoderEOS;
    }

    @Override
    public void release() {
        if (this.mDecoderOutputSurfaceWrapper != null) {
            this.mDecoderOutputSurfaceWrapper.release();
            this.mDecoderOutputSurfaceWrapper = null;
        }
        if (this.mEncoderInputSurfaceWrapper != null) {
            this.mEncoderInputSurfaceWrapper.release();
            this.mEncoderInputSurfaceWrapper = null;
        }
        if (this.mDecoder != null) {
            if (this.mDecoderStarted) {
                this.mDecoder.stop();
            }
            this.mDecoder.release();
            this.mDecoder = null;
        }
        if (this.mEncoder != null) {
            if (this.mEncoderStarted) {
                this.mEncoder.stop();
            }
            this.mEncoder.release();
            this.mEncoder = null;
        }
    }

    private int drainExtractor(long timeoutUs) {
        if (this.mIsExtractorEOS) {
            return 0;
        }
        int trackIndex = this.mExtractor.getSampleTrackIndex();
        if (trackIndex >= 0 && trackIndex != this.mTrackIndex) {
            return 0;
        }
        int result = this.mDecoder.dequeueInputBuffer(timeoutUs);
        if (result < 0) {
            return 0;
        }
        if (trackIndex < 0) {
            this.mIsExtractorEOS = true;
            this.mDecoder.queueInputBuffer(result, 0, 0, 0L, 4);
            return 0;
        }
        int sampleSize = this.mExtractor.readSampleData(this.mDecoderInputBuffers[result], 0);
        boolean isKeyFrame = (this.mExtractor.getSampleFlags() & 1) != 0;
        this.mDecoder.queueInputBuffer(result, 0, sampleSize, this.mExtractor.getSampleTime(), isKeyFrame ? 1 : 0);
        this.mExtractor.advance();
        return 2;
    }

    private int drainDecoder(long timeoutUs) {
        if (this.mIsDecoderEOS) {
            return 0;
        }
        int result = this.mDecoder.dequeueOutputBuffer(this.mBufferInfo, timeoutUs);
        switch (result) {
            case -1: {
                return 0;
            }
            case -3: 
            case -2: {
                return 1;
            }
        }
        if ((this.mBufferInfo.flags & 4) != 0) {
            this.mEncoder.signalEndOfInputStream();
            this.mIsDecoderEOS = true;
            this.mBufferInfo.size = 0;
        }
        boolean doRender = this.mBufferInfo.size > 0;
        this.mDecoder.releaseOutputBuffer(result, doRender);
        if (doRender) {
            this.mDecoderOutputSurfaceWrapper.awaitNewImage();
            this.mDecoderOutputSurfaceWrapper.drawImage();
            this.mEncoderInputSurfaceWrapper.setPresentationTime(this.mBufferInfo.presentationTimeUs * 1000L);
            this.mEncoderInputSurfaceWrapper.swapBuffers();
        }
        return 2;
    }

    private int drainEncoder(long timeoutUs) {
        if (this.mIsEncoderEOS) {
            return 0;
        }
        int result = this.mEncoder.dequeueOutputBuffer(this.mBufferInfo, timeoutUs);
        switch (result) {
            case -1: {
                return 0;
            }
            case -2: {
                if (this.mActualOutputFormat != null) {
                    throw new RuntimeException("Video output format changed twice.");
                }
                this.mActualOutputFormat = this.mEncoder.getOutputFormat();
                this.mMuxer.setOutputFormat(QueuedMuxer.SampleType.VIDEO, this.mActualOutputFormat);
                return 1;
            }
            case -3: {
                this.mEncoderOutputBuffers = this.mEncoder.getOutputBuffers();
                return 1;
            }
        }
        if (this.mActualOutputFormat == null) {
            throw new RuntimeException("Could not determine actual output format.");
        }
        if ((this.mBufferInfo.flags & 4) != 0) {
            this.mIsEncoderEOS = true;
            this.mBufferInfo.set(0, 0, 0L, this.mBufferInfo.flags);
        }
        if ((this.mBufferInfo.flags & 2) != 0) {
            this.mEncoder.releaseOutputBuffer(result, false);
            return 1;
        }
        this.mMuxer.writeSampleData(QueuedMuxer.SampleType.VIDEO, this.mEncoderOutputBuffers[result], this.mBufferInfo);
        this.mWrittenPresentationTimeUs = this.mBufferInfo.presentationTimeUs;
        this.mEncoder.releaseOutputBuffer(result, false);
        return 2;
    }
}

