/*
 * Decompiled with CFR 0.152.
 */
package com.guoxiaoxing.phoenix.compress.video.engine;

import android.media.MediaFormat;
import com.guoxiaoxing.phoenix.compress.video.engine.InvalidOutputFormatException;
import com.guoxiaoxing.phoenix.compress.video.utils.AvcCsdUtils;
import com.guoxiaoxing.phoenix.compress.video.utils.AvcSpsUtils;
import java.nio.ByteBuffer;

class MediaFormatValidator {
    private static final byte PROFILE_IDC_BASELINE = 66;

    MediaFormatValidator() {
    }

    public static void validateVideoOutputFormat(MediaFormat format) {
        String mime = format.getString("mime");
        if (!"video/avc".equals(mime)) {
            throw new InvalidOutputFormatException("Video codecs other than AVC is not supported, actual mime type: " + mime);
        }
        ByteBuffer spsBuffer = AvcCsdUtils.getSpsBuffer(format);
        byte profileIdc = AvcSpsUtils.getProfileIdc(spsBuffer);
        if (profileIdc != 66) {
            throw new InvalidOutputFormatException("Non-baseline AVC video profile is not supported by Android OS, actual profile_idc: " + profileIdc);
        }
    }

    public static void validateAudioOutputFormat(MediaFormat format) {
        String mime = format.getString("mime");
        if (!"audio/mp4a-latm".equals(mime)) {
            throw new InvalidOutputFormatException("Audio codecs other than AAC is not supported, actual mime type: " + mime);
        }
    }
}

