/*
 * Decompiled with CFR 0.152.
 */
package com.guoxiaoxing.phoenix.compress.video;

import android.media.MediaFormat;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.guoxiaoxing.phoenix.compress.video.engine.MediaTranscoderEngine;
import com.guoxiaoxing.phoenix.compress.video.format.MediaFormatPresets;
import com.guoxiaoxing.phoenix.compress.video.format.MediaFormatStrategy;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class VideoCompressor {
    private static final String TAG = "VideoCompressor";
    private static final int MAXIMUM_THREAD = 1;
    private static volatile VideoCompressor sVideoCompressor;
    private ThreadPoolExecutor mExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "VideoCompressor-Worker");
        }
    });

    private VideoCompressor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VideoCompressor with() {
        if (sVideoCompressor != null) return sVideoCompressor;
        Class<VideoCompressor> clazz = VideoCompressor.class;
        synchronized (VideoCompressor.class) {
            if (sVideoCompressor != null) return sVideoCompressor;
            sVideoCompressor = new VideoCompressor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sVideoCompressor;
        }
    }

    public String syncTranscodeVideo(String inPath, String outPath, MediaFormatStrategy outFormatStrategy) throws IOException {
        FileDescriptor inFileDescriptor;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(inPath);
            inFileDescriptor = fileInputStream.getFD();
        }
        catch (IOException e) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException eClose) {
                    Log.e((String)TAG, (String)"Can't close input stream: ", (Throwable)eClose);
                }
            }
            throw e;
        }
        Exception caughtException = null;
        try {
            MediaTranscoderEngine engine = new MediaTranscoderEngine();
            engine.setDataSource(inFileDescriptor);
            engine.transcodeVideo(outPath, outFormatStrategy);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("Transcode failed: input file (fd: " + inFileDescriptor.toString() + ") not found or could not open output file ('" + outPath + "') ."), (Throwable)e);
            caughtException = e;
        }
        catch (InterruptedException e) {
            Log.i((String)TAG, (String)"Cancel transcode video file.", (Throwable)e);
            caughtException = e;
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Fatal error while transcoding, this might be invalid format or bug in engine or Android.", (Throwable)e);
            caughtException = e;
        }
        Exception exception = caughtException;
        if (exception == null) {
            try {
                fileInputStream.close();
            }
            catch (IOException eClose) {
                Log.e((String)TAG, (String)"Can't close input stream: ", (Throwable)eClose);
            }
            return outPath;
        }
        try {
            fileInputStream.close();
        }
        catch (IOException eClose) {
            Log.e((String)TAG, (String)"Can't close input stream: ", (Throwable)eClose);
        }
        return null;
    }

    @Deprecated
    public Future<Void> asyncTranscodeVideo(FileDescriptor inFileDescriptor, String outPath, Listener listener) {
        return this.asyncTranscodeVideo(inFileDescriptor, outPath, new MediaFormatStrategy(){

            @Override
            public MediaFormat createVideoOutputFormat(MediaFormat inputFormat) {
                return MediaFormatPresets.getExportPreset960x540();
            }

            @Override
            public MediaFormat createAudioOutputFormat(MediaFormat inputFormat) {
                return null;
            }
        }, listener);
    }

    public Future<Void> asyncTranscodeVideo(String inPath, String outPath, MediaFormatStrategy outFormatStrategy, final Listener listener) throws IOException {
        FileDescriptor inFileDescriptor;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(inPath);
            inFileDescriptor = fileInputStream.getFD();
        }
        catch (IOException e) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException eClose) {
                    Log.e((String)TAG, (String)"Can't close input stream: ", (Throwable)eClose);
                }
            }
            throw e;
        }
        final FileInputStream finalFileInputStream = fileInputStream;
        return this.asyncTranscodeVideo(inFileDescriptor, outPath, outFormatStrategy, new Listener(){

            @Override
            public void onTranscodeProgress(double progress) {
                listener.onTranscodeProgress(progress);
            }

            @Override
            public void onTranscodeCompleted() {
                this.closeStream();
                listener.onTranscodeCompleted();
            }

            @Override
            public void onTranscodeCanceled() {
                this.closeStream();
                listener.onTranscodeCanceled();
            }

            @Override
            public void onTranscodeFailed(Exception exception) {
                this.closeStream();
                listener.onTranscodeFailed(exception);
            }

            private void closeStream() {
                try {
                    finalFileInputStream.close();
                }
                catch (IOException e) {
                    Log.e((String)VideoCompressor.TAG, (String)"Can't close input stream: ", (Throwable)e);
                }
            }
        });
    }

    public Future<Void> asyncTranscodeVideo(final FileDescriptor inFileDescriptor, final String outPath, final MediaFormatStrategy outFormatStrategy, final Listener listener) {
        Looper looper = Looper.myLooper();
        if (looper == null) {
            looper = Looper.getMainLooper();
        }
        final Handler handler = new Handler(looper);
        final AtomicReference<Future<Void>> futureReference = new AtomicReference<Future<Void>>();
        Future<Void> createdFuture = this.mExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Exception caughtException = null;
                try {
                    MediaTranscoderEngine engine = new MediaTranscoderEngine();
                    engine.setProgressCallback(new MediaTranscoderEngine.ProgressCallback(){

                        @Override
                        public void onProgress(final double progress) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onTranscodeProgress(progress);
                                }
                            });
                        }
                    });
                    engine.setDataSource(inFileDescriptor);
                    engine.transcodeVideo(outPath, outFormatStrategy);
                }
                catch (IOException e) {
                    Log.w((String)VideoCompressor.TAG, (String)("Transcode failed: input file (fd: " + inFileDescriptor.toString() + ") not found or could not open output file ('" + outPath + "') ."), (Throwable)e);
                    caughtException = e;
                }
                catch (InterruptedException e) {
                    Log.i((String)VideoCompressor.TAG, (String)"Cancel transcode video file.", (Throwable)e);
                    caughtException = e;
                }
                catch (RuntimeException e) {
                    Log.e((String)VideoCompressor.TAG, (String)"Fatal error while transcoding, this might be invalid format or bug in engine or Android.", (Throwable)e);
                    caughtException = e;
                }
                final Exception exception = caughtException;
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (exception == null) {
                            listener.onTranscodeCompleted();
                        } else {
                            Future future = (Future)futureReference.get();
                            if (future != null && future.isCancelled()) {
                                listener.onTranscodeCanceled();
                            } else {
                                listener.onTranscodeFailed(exception);
                            }
                        }
                    }
                });
                if (exception != null) {
                    throw exception;
                }
                return null;
            }
        });
        futureReference.set(createdFuture);
        return createdFuture;
    }

    public static interface Listener {
        public void onTranscodeProgress(double var1);

        public void onTranscodeCompleted();

        public void onTranscodeCanceled();

        public void onTranscodeFailed(Exception var1);
    }
}

