/*
 * Decompiled with CFR 0.152.
 */
package com.github.guilhe.sharedprefsutils;

import android.content.SharedPreferences;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;

public class SharedPrefsUtils {
    private static final String TAG = SharedPrefsUtils.class.getSimpleName();

    public static boolean putObject(SharedPreferences prefs, String key, Object object) {
        return SharedPrefsUtils.putObject(prefs, key, object, new Gson());
    }

    public static boolean putObject(SharedPreferences prefs, String key, Object object, Gson gson) {
        if (prefs == null) {
            throw new IllegalArgumentException("SharedPreferences must not be null");
        }
        if (key == null || key.equals("")) {
            throw new IllegalArgumentException("Key must not be empty or null");
        }
        if (gson == null) {
            throw new IllegalArgumentException("Gson must not be null");
        }
        Log.i((String)TAG, (String)("> putObject, storing " + (object == null ? "null object" : object.getClass().getSimpleName()) + " with key \"" + key + "\""));
        return prefs.edit().putString(key, gson.toJson(object)).commit();
    }

    public static <T> T getObject(SharedPreferences prefs, String key, TypeToken<T> type, T defaultValue) {
        return SharedPrefsUtils.getObject(prefs, key, type, defaultValue, new Gson());
    }

    public static <T> T getObject(SharedPreferences prefs, String key, TypeToken<T> type, T defaultValue, Gson gson) {
        if (!SharedPrefsUtils.assertNotNull(prefs, key, type, gson)) {
            return defaultValue;
        }
        String json = prefs.getString(key, null);
        if (json == null) {
            Log.w((String)TAG, (String)"> getObject, json is null, returning defaultValue");
            return defaultValue;
        }
        try {
            return (T)gson.fromJson(json, type.getType());
        }
        catch (JsonSyntaxException e) {
            throw new JsonParseException("> getObject, Object stored with Key " + key + " is instance of other class.");
        }
    }

    public static <T> T getObject(SharedPreferences prefs, String key, Class<T> object, T defaultValue) {
        return SharedPrefsUtils.getObject(prefs, key, object, defaultValue, new Gson());
    }

    public static <T> T getObject(SharedPreferences prefs, String key, Class<T> object, T defaultValue, Gson gson) {
        if (!SharedPrefsUtils.assertNotNull(prefs, key, object, gson)) {
            return defaultValue;
        }
        String json = prefs.getString(key, null);
        if (json == null) {
            Log.w((String)TAG, (String)"> getObject, json is null, returning defaultValue");
            return defaultValue;
        }
        try {
            return (T)gson.fromJson(json, object);
        }
        catch (JsonSyntaxException e) {
            throw new JsonParseException("> getObject, Object stored with Key " + key + " is instance of other class.");
        }
    }

    private static boolean assertNotNull(SharedPreferences prefs, String key, Object object, Gson gson) {
        if (prefs == null) {
            Log.w((String)TAG, (String)"> getObject, SharedPreferences must not be null");
            return false;
        }
        if (key == null || key.equals("")) {
            Log.w((String)TAG, (String)"> getObject, Key must not be null or empty");
            return false;
        }
        if (object == null) {
            Log.w((String)TAG, (String)"> getObject, Type or Object must not be null");
            return false;
        }
        if (gson == null) {
            Log.w((String)TAG, (String)"> getObject, Gson must not be null");
            return false;
        }
        return true;
    }
}

