/*
 * Decompiled with CFR 0.152.
 */
package com.grum.geocalc;

import com.grum.geocalc.Coordinate;
import java.io.Serializable;
import lombok.Generated;

public class Point
implements Serializable {
    public final double latitude;
    public final double longitude;

    private Point(Coordinate latitude, Coordinate longitude) {
        this.latitude = latitude.degrees();
        this.longitude = longitude.degrees();
    }

    public static Point at(Coordinate latitude, Coordinate longitude) {
        return new Point(latitude.degrees(), longitude.degrees());
    }

    public String toString() {
        return "Point{latitude=" + this.latitude + ", longitude=" + this.longitude + '}';
    }

    @Generated
    Point(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.latitude, other.latitude) != 0) {
            return false;
        }
        return Double.compare(this.longitude, other.longitude) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Point;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $latitude = Double.doubleToLongBits(this.latitude);
        result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
        long $longitude = Double.doubleToLongBits(this.longitude);
        result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
        return result;
    }
}

