/*
 * Decompiled with CFR 0.152.
 */
package com.grum.geocalc;

import com.grum.geocalc.BoundingArea;
import com.grum.geocalc.Coordinate;
import com.grum.geocalc.Point;
import lombok.Generated;

public class EarthCalc {
    public static final double EARTH_RADIUS = 6356752.314245;

    public static class vincenty {
        private static Vincenty vincenty(Point standPoint, Point forePoint) {
            double cos\u03bb;
            double sin\u03bb;
            double \u03bb\u02b9;
            double cos\u03c3;
            double cos2\u03c3M;
            double sin\u03c3;
            double \u03c3;
            double sin\u03b1;
            double cosSq\u03b1;
            double C;
            double \u03bb1 = Math.toRadians(standPoint.longitude);
            double \u03bb2 = Math.toRadians(forePoint.longitude);
            double \u03c61 = Math.toRadians(standPoint.latitude);
            double \u03c62 = Math.toRadians(forePoint.latitude);
            double a = 6378137.0;
            double b = 6356752.314245;
            double f = 0.0033528106647474805;
            double L = \u03bb2 - \u03bb1;
            double tanU1 = 0.9966471893352525 * Math.tan(\u03c61);
            double cosU1 = 1.0 / Math.sqrt(1.0 + tanU1 * tanU1);
            double sinU1 = tanU1 * cosU1;
            double tanU2 = 0.9966471893352525 * Math.tan(\u03c62);
            double cosU2 = 1.0 / Math.sqrt(1.0 + tanU2 * tanU2);
            double sinU2 = tanU2 * cosU2;
            double \u03bb = L;
            double iterationLimit = 100.0;
            do {
                double sinSq\u03c3;
                if ((sin\u03c3 = Math.sqrt(sinSq\u03c3 = cosU2 * (sin\u03bb = Math.sin(\u03bb)) * (cosU2 * sin\u03bb) + (cosU1 * sinU2 - sinU1 * cosU2 * (cos\u03bb = Math.cos(\u03bb))) * (cosU1 * sinU2 - sinU1 * cosU2 * cos\u03bb))) == 0.0) {
                    return Vincenty.CO_INCIDENT_POINTS;
                }
                cos\u03c3 = sinU1 * sinU2 + cosU1 * cosU2 * cos\u03bb;
                \u03c3 = Math.atan2(sin\u03c3, cos\u03c3);
                sin\u03b1 = cosU1 * cosU2 * sin\u03bb / sin\u03c3;
                cosSq\u03b1 = 1.0 - sin\u03b1 * sin\u03b1;
                cos2\u03c3M = cos\u03c3 - 2.0 * sinU1 * sinU2 / cosSq\u03b1;
                if (!Double.isNaN(cos2\u03c3M)) continue;
                cos2\u03c3M = 0.0;
            } while (Math.abs((\u03bb = L + (1.0 - (C = 2.0955066654671753E-4 * cosSq\u03b1 * (4.0 + 0.0033528106647474805 * (4.0 - 3.0 * cosSq\u03b1)))) * 0.0033528106647474805 * sin\u03b1 * (\u03c3 + C * sin\u03c3 * (cos2\u03c3M + C * cos\u03c3 * (-1.0 + 2.0 * cos2\u03c3M * cos2\u03c3M)))) - (\u03bb\u02b9 = \u03bb)) > 1.0E-12 && (iterationLimit -= 1.0) > 0.0);
            if (iterationLimit == 0.0) {
                throw new IllegalStateException("Formula failed to converge");
            }
            double uSq = cosSq\u03b1 * 2.7233160610984375E11 / 4.040829998465916E13;
            double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
            double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
            double \u0394\u03c3 = B * sin\u03c3 * (cos2\u03c3M + B / 4.0 * (cos\u03c3 * (-1.0 + 2.0 * cos2\u03c3M * cos2\u03c3M) - B / 6.0 * cos2\u03c3M * (-3.0 + 4.0 * sin\u03c3 * sin\u03c3) * (-3.0 + 4.0 * cos2\u03c3M * cos2\u03c3M)));
            double distance = 6356752.314245 * A * (\u03c3 - \u0394\u03c3);
            double initialBearing = Math.atan2(cosU2 * sin\u03bb, cosU1 * sinU2 - sinU1 * cosU2 * cos\u03bb);
            initialBearing = (initialBearing + Math.PI * 2) % (Math.PI * 2);
            double finalBearing = Math.atan2(cosU1 * sin\u03bb, -sinU1 * cosU2 + cosU1 * sinU2 * cos\u03bb);
            finalBearing = (finalBearing + Math.PI * 2) % (Math.PI * 2);
            return new Vincenty(distance, Math.toDegrees(initialBearing), Math.toDegrees(finalBearing));
        }

        public static double distance(Point standPoint, Point forePoint) {
            return vincenty.vincenty((Point)standPoint, (Point)forePoint).distance;
        }

        public static double bearing(Point standPoint, Point forePoint) {
            return vincenty.vincenty((Point)standPoint, (Point)forePoint).initialBearing;
        }

        public static double finalBearing(Point standPoint, Point forePoint) {
            return vincenty.vincenty((Point)standPoint, (Point)forePoint).finalBearing;
        }

        private static class Vincenty {
            static final Vincenty CO_INCIDENT_POINTS = new Vincenty(0.0, 0.0, 0.0);
            final double distance;
            final double initialBearing;
            final double finalBearing;

            @Generated
            public Vincenty(double distance, double initialBearing, double finalBearing) {
                this.distance = distance;
                this.initialBearing = initialBearing;
                this.finalBearing = finalBearing;
            }
        }
    }

    public static class haversine {
        public static double distance(Point standPoint, Point forePoint) {
            double \u0394\u03bb = Math.toRadians(Math.abs(forePoint.longitude - standPoint.longitude));
            double \u03c61 = Math.toRadians(standPoint.latitude);
            double \u03c62 = Math.toRadians(forePoint.latitude);
            double \u0394\u03c6 = Math.toRadians(Math.abs(forePoint.latitude - standPoint.latitude));
            double a = Math.sin(\u0394\u03c6 / 2.0) * Math.sin(\u0394\u03c6 / 2.0) + Math.cos(\u03c61) * Math.cos(\u03c62) * Math.sin(\u0394\u03bb / 2.0) * Math.sin(\u0394\u03bb / 2.0);
            double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
            return 6356752.314245 * c;
        }
    }

    public static class gcd {
        public static Point midPoint(Point standPoint, Point forePoint) {
            double \u03bb1 = Math.toRadians(standPoint.longitude);
            double \u03bb2 = Math.toRadians(forePoint.longitude);
            double \u03c61 = Math.toRadians(standPoint.latitude);
            double \u03c62 = Math.toRadians(forePoint.latitude);
            double Bx = Math.cos(\u03c62) * Math.cos(\u03bb2 - \u03bb1);
            double By = Math.cos(\u03c62) * Math.sin(\u03bb2 - \u03bb1);
            double \u03c63 = Math.atan2(Math.sin(\u03c61) + Math.sin(\u03c62), Math.sqrt((Math.cos(\u03c61) + Bx) * (Math.cos(\u03c61) + Bx) + By * By));
            double \u03bb3 = \u03bb1 + Math.atan2(By, Math.cos(\u03c61) + Bx);
            return Point.at(Coordinate.fromRadians(\u03c63), Coordinate.fromRadians(\u03bb3));
        }

        public static double distance(Point standPoint, Point forePoint) {
            double \u0394\u03bb = Math.toRadians(Math.abs(forePoint.longitude - standPoint.longitude));
            double \u03c61 = Math.toRadians(standPoint.latitude);
            double \u03c62 = Math.toRadians(forePoint.latitude);
            double sphereCos = Math.sin(\u03c61) * Math.sin(\u03c62) + Math.cos(\u03c61) * Math.cos(\u03c62) * Math.cos(\u0394\u03bb);
            double c = Math.acos(Math.max(Math.min(sphereCos, 1.0), -1.0));
            return 6356752.314245 * c;
        }

        public static Point pointAt(Point standPoint, double bearing, double distance) {
            double \u03c61 = Math.toRadians(standPoint.latitude);
            double \u03bb1 = Math.toRadians(standPoint.longitude);
            double \u03b8 = Math.toRadians(bearing);
            double \u03b4 = distance / 6356752.314245;
            double \u03c62 = Math.asin(Math.sin(\u03c61) * Math.cos(\u03b4) + Math.cos(\u03c61) * Math.sin(\u03b4) * Math.cos(\u03b8));
            double \u03bb2 = \u03bb1 + Math.atan2(Math.sin(\u03b8) * Math.sin(\u03b4) * Math.cos(\u03c61), Math.cos(\u03b4) - Math.sin(\u03c61) * Math.sin(\u03c62));
            double \u03bb2_harmonised = (\u03bb2 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
            return Point.at(Coordinate.fromRadians(\u03c62), Coordinate.fromRadians(\u03bb2_harmonised));
        }

        public static double bearing(Point standPoint, Point forePoint) {
            double \u0394long = Math.toRadians(forePoint.longitude - standPoint.longitude);
            double y = Math.sin(\u0394long) * Math.cos(Math.toRadians(forePoint.latitude));
            double x = Math.cos(Math.toRadians(standPoint.latitude)) * Math.sin(Math.toRadians(forePoint.latitude)) - Math.sin(Math.toRadians(standPoint.latitude)) * Math.cos(Math.toRadians(forePoint.latitude)) * Math.cos(\u0394long);
            double bearing = (Math.atan2(y, x) + Math.PI * 2) % (Math.PI * 2);
            return Math.toDegrees(bearing);
        }

        public static BoundingArea around(Point standPoint, double distance) {
            Point northEast = gcd.pointAt(standPoint, 45.0, distance);
            Point southWest = gcd.pointAt(standPoint, 225.0, distance);
            return BoundingArea.at(northEast, southWest);
        }
    }
}

