/*
 * Decompiled with CFR 0.152.
 */
package com.grum.geocalc;

import com.grum.geocalc.DMSCoordinate;
import com.grum.geocalc.DegreeCoordinate;
import com.grum.geocalc.GPSCoordinate;
import com.grum.geocalc.RadianCoordinate;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;

public abstract class Coordinate
implements Serializable {
    abstract double degrees();

    public static DegreeCoordinate fromDegrees(double decimalDegrees) {
        return new DegreeCoordinate(decimalDegrees);
    }

    public static DMSCoordinate fromDMS(double wholeDegrees, double minutes, double seconds) {
        return new DMSCoordinate(wholeDegrees, minutes, seconds);
    }

    public static GPSCoordinate fromGPS(double wholeDegrees, double minutes) {
        return new GPSCoordinate(wholeDegrees, minutes);
    }

    public static RadianCoordinate fromRadians(double radians) {
        return new RadianCoordinate(radians);
    }

    DMSCoordinate toDMSCoordinate() {
        int wholeDegrees = (int)this.degrees();
        double remaining = Math.abs(this.degrees() - (double)wholeDegrees);
        int minutes = (int)(remaining * 60.0);
        remaining = remaining * 60.0 - (double)minutes;
        double seconds = new BigDecimal(remaining * 60.0).setScale(4, RoundingMode.HALF_UP).doubleValue();
        return new DMSCoordinate(wholeDegrees, minutes, seconds);
    }

    DegreeCoordinate toDegreeCoordinate() {
        return new DegreeCoordinate(this.degrees());
    }

    GPSCoordinate toGPSCoordinate() {
        double wholeDegrees = Math.floor(this.degrees());
        double remaining = this.degrees() - wholeDegrees;
        double minutes = Math.floor(remaining * 60.0);
        return new GPSCoordinate(wholeDegrees, minutes);
    }

    RadianCoordinate toRadianCoordinate() {
        return new RadianCoordinate(Math.toRadians(this.degrees()));
    }
}

