/*
 * Decompiled with CFR 0.152.
 */
package com.grum.geocalc;

import com.grum.geocalc.Coordinate;
import com.grum.geocalc.Point;
import lombok.Generated;

public class BoundingArea {
    public final Point northEast;
    public final Point southWest;
    public final Point southEast;
    public final Point northWest;

    private BoundingArea(Point northEast, Point southWest) {
        this.northEast = northEast;
        this.southWest = southWest;
        this.southEast = Point.at(Coordinate.fromDegrees(southWest.latitude), Coordinate.fromDegrees(northEast.longitude));
        this.northWest = Point.at(Coordinate.fromDegrees(northEast.latitude), Coordinate.fromDegrees(southWest.longitude));
    }

    public static BoundingArea at(Point northEast, Point southWest) {
        return new BoundingArea(northEast, southWest);
    }

    public String toString() {
        return "BoundingArea{northEast=" + this.northEast + ", southWest=" + this.southWest + '}';
    }

    @Deprecated
    public boolean isContainedWithin(Point point) {
        return this.contains(point);
    }

    public boolean contains(Point point) {
        boolean predicate2;
        boolean predicate1;
        boolean bl = predicate1 = point.latitude >= this.southWest.latitude && point.latitude <= this.northEast.latitude;
        if (!predicate1) {
            return false;
        }
        if (this.southWest.longitude > this.northEast.longitude) {
            boolean predicate3 = point.longitude <= this.northEast.longitude && point.longitude >= -180.0;
            boolean predicate4 = point.longitude >= this.southWest.longitude && point.longitude <= 180.0;
            predicate2 = predicate3 || predicate4;
        } else {
            predicate2 = point.longitude >= this.southWest.longitude && point.longitude <= this.northEast.longitude;
        }
        return predicate2;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoundingArea)) {
            return false;
        }
        BoundingArea other = (BoundingArea)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Point this$northEast = this.northEast;
        Point other$northEast = other.northEast;
        if (this$northEast == null ? other$northEast != null : !((Object)this$northEast).equals(other$northEast)) {
            return false;
        }
        Point this$southWest = this.southWest;
        Point other$southWest = other.southWest;
        if (this$southWest == null ? other$southWest != null : !((Object)this$southWest).equals(other$southWest)) {
            return false;
        }
        Point this$southEast = this.southEast;
        Point other$southEast = other.southEast;
        if (this$southEast == null ? other$southEast != null : !((Object)this$southEast).equals(other$southEast)) {
            return false;
        }
        Point this$northWest = this.northWest;
        Point other$northWest = other.northWest;
        return !(this$northWest == null ? other$northWest != null : !((Object)this$northWest).equals(other$northWest));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BoundingArea;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Point $northEast = this.northEast;
        result = result * 59 + ($northEast == null ? 43 : ((Object)$northEast).hashCode());
        Point $southWest = this.southWest;
        result = result * 59 + ($southWest == null ? 43 : ((Object)$southWest).hashCode());
        Point $southEast = this.southEast;
        result = result * 59 + ($southEast == null ? 43 : ((Object)$southEast).hashCode());
        Point $northWest = this.northWest;
        result = result * 59 + ($northWest == null ? 43 : ((Object)$northWest).hashCode());
        return result;
    }
}

