/*
 * Decompiled with CFR 0.152.
 */
package com.grum.geocalc;

import com.grum.geocalc.DMSCoordinate;
import com.grum.geocalc.DegreeCoordinate;
import com.grum.geocalc.GPSCoordinate;
import com.grum.geocalc.RadianCoordinate;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;

public abstract class Coordinate
implements Serializable {
    abstract double degrees();

    @Deprecated
    public double getValue() {
        return this.degrees();
    }

    public static DegreeCoordinate fromDegrees(double decimalDegrees) {
        return new DegreeCoordinate(decimalDegrees);
    }

    public static DMSCoordinate fromDMS(double wholeDegrees, double minutes, double seconds) {
        return new DMSCoordinate(wholeDegrees, minutes, seconds);
    }

    public static GPSCoordinate fromGPS(double wholeDegrees, double minutes) {
        return new GPSCoordinate(wholeDegrees, minutes);
    }

    public static RadianCoordinate fromRadians(double radians) {
        return new RadianCoordinate(radians);
    }

    DMSCoordinate toDMSCoordinate() {
        double _wholeDegrees = (int)this.degrees();
        double remaining = Math.abs(this.degrees() - _wholeDegrees);
        double _minutes = (int)(remaining * 60.0);
        remaining = remaining * 60.0 - _minutes;
        double _seconds = new BigDecimal(remaining * 60.0).setScale(4, RoundingMode.HALF_UP).doubleValue();
        return new DMSCoordinate(_wholeDegrees, _minutes, _seconds);
    }

    DegreeCoordinate toDegreeCoordinate() {
        return new DegreeCoordinate(this.degrees());
    }

    GPSCoordinate toGPSCoordinate() {
        double _wholeDegrees = Math.floor(this.degrees());
        double remaining = this.degrees() - _wholeDegrees;
        double _minutes = Math.floor(remaining * 60.0);
        return new GPSCoordinate(_wholeDegrees, _minutes);
    }

    RadianCoordinate toRadianCoordinate() {
        return new RadianCoordinate(Math.toRadians(this.degrees()));
    }
}

