/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.IGrowthBook;
import growthbook.sdk.java.callback.ExperimentRunCallback;
import growthbook.sdk.java.evaluators.ConditionEvaluator;
import growthbook.sdk.java.evaluators.ExperimentEvaluator;
import growthbook.sdk.java.evaluators.FeatureEvaluator;
import growthbook.sdk.java.model.AssignedExperiment;
import growthbook.sdk.java.model.Experiment;
import growthbook.sdk.java.model.ExperimentResult;
import growthbook.sdk.java.model.FeatureResult;
import growthbook.sdk.java.model.GBContext;
import growthbook.sdk.java.model.StickyAssignmentsDocument;
import growthbook.sdk.java.multiusermode.configurations.EvaluationContext;
import growthbook.sdk.java.multiusermode.configurations.GlobalContext;
import growthbook.sdk.java.multiusermode.configurations.Options;
import growthbook.sdk.java.multiusermode.configurations.UserContext;
import growthbook.sdk.java.multiusermode.usage.FeatureUsageCallbackAdapter;
import growthbook.sdk.java.multiusermode.usage.TrackingCallbackAdapter;
import growthbook.sdk.java.stickyBucketing.InMemoryStickyBucketServiceImpl;
import growthbook.sdk.java.stickyBucketing.StickyBucketService;
import growthbook.sdk.java.util.GrowthBookJsonUtils;
import growthbook.sdk.java.util.GrowthBookUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrowthBook
implements IGrowthBook {
    private static final Logger log = LoggerFactory.getLogger(GrowthBook.class);
    private final GBContext context;
    private final FeatureEvaluator featureEvaluator;
    private final ConditionEvaluator conditionEvaluator;
    private final ExperimentEvaluator experimentEvaluatorEvaluator;
    private final GrowthBookJsonUtils jsonUtils = GrowthBookJsonUtils.getInstance();
    private List<ExperimentRunCallback> callbacks;
    private JsonObject attributeOverrides;
    private JsonObject savedGroups;
    public EvaluationContext evaluationContext = null;
    private final Map<String, AssignedExperiment> assigned;
    private Map<String, Object> forcedFeatureValues;

    public GrowthBook(GBContext context) {
        this.context = context;
        this.assigned = new HashMap<String, AssignedExperiment>();
        this.callbacks = new ArrayList<ExperimentRunCallback>();
        this.featureEvaluator = new FeatureEvaluator();
        this.conditionEvaluator = new ConditionEvaluator();
        this.experimentEvaluatorEvaluator = new ExperimentEvaluator();
        this.attributeOverrides = context.getAttributes() == null ? new JsonObject() : context.getAttributes();
        this.savedGroups = context.getSavedGroups() == null ? new JsonObject() : context.getSavedGroups();
        this.initializeEvalContext();
    }

    public GrowthBook() {
        this.context = GBContext.builder().build();
        this.assigned = new HashMap<String, AssignedExperiment>();
        this.callbacks = new ArrayList<ExperimentRunCallback>();
        this.featureEvaluator = new FeatureEvaluator();
        this.conditionEvaluator = new ConditionEvaluator();
        this.experimentEvaluatorEvaluator = new ExperimentEvaluator();
        this.attributeOverrides = this.context.getAttributes() == null ? new JsonObject() : this.context.getAttributes();
        this.savedGroups = this.context.getSavedGroups() == null ? new JsonObject() : this.context.getSavedGroups();
        this.initializeEvalContext();
    }

    GrowthBook(GBContext context, FeatureEvaluator featureEvaluator, ConditionEvaluator conditionEvaluator, ExperimentEvaluator experimentEvaluator) {
        this.featureEvaluator = featureEvaluator;
        this.conditionEvaluator = conditionEvaluator;
        this.experimentEvaluatorEvaluator = experimentEvaluator;
        this.context = context;
        this.assigned = new HashMap<String, AssignedExperiment>();
        this.callbacks = new ArrayList<ExperimentRunCallback>();
        this.attributeOverrides = context.getAttributes() == null ? new JsonObject() : context.getAttributes();
        this.savedGroups = context.getSavedGroups() == null ? new JsonObject() : context.getSavedGroups();
        this.initializeEvalContext();
    }

    private void initializeEvalContext() {
        Options options = Options.builder().enabled(this.context.getEnabled()).isQaMode(this.context.getIsQaMode()).allowUrlOverrides(this.context.getAllowUrlOverride()).url(this.context.getUrl()).stickyBucketIdentifierAttributes(this.context.getStickyBucketIdentifierAttributes()).stickyBucketService(this.context.getStickyBucketService()).trackingCallBackWithUser(new TrackingCallbackAdapter(this.context.getTrackingCallback())).featureUsageCallbackWithUser(new FeatureUsageCallbackAdapter(this.context.getFeatureUsageCallback())).globalForcedFeatureValues(this.forcedFeatureValues).build();
        GlobalContext globalContext = GlobalContext.builder().features(this.context.getFeatures()).savedGroups(this.context.getSavedGroups()).forcedFeatureValues(this.forcedFeatureValues).build();
        UserContext userContext = UserContext.builder().attributes(this.context.getAttributes()).stickyBucketAssignmentDocs(this.context.getStickyBucketAssignmentDocs()).forcedVariationsMap(this.context.getForcedVariationsMap()).forcedFeatureValues(this.forcedFeatureValues).build();
        this.evaluationContext = new EvaluationContext(globalContext, userContext, new EvaluationContext.StackContext(), options);
    }

    private EvaluationContext getEvaluationContext() {
        this.evaluationContext.setStack(new EvaluationContext.StackContext());
        return this.evaluationContext;
    }

    @Override
    @Nullable
    public <ValueType> FeatureResult<ValueType> evalFeature(String key, Class<ValueType> valueTypeClass) {
        return this.featureEvaluator.evaluateFeature(key, this.getEvaluationContext(), valueTypeClass);
    }

    @Override
    public void setFeatures(String featuresJsonString) {
        this.context.setFeaturesJson(featuresJsonString);
        this.initializeEvalContext();
    }

    @Override
    public void setSavedGroups(JsonObject savedGroups) {
        this.context.setSavedGroups(savedGroups);
        this.savedGroups = savedGroups;
        this.initializeEvalContext();
    }

    @Override
    public void setAttributes(String attributesJsonString) {
        this.context.setAttributesJson(attributesJsonString);
        this.initializeEvalContext();
    }

    @Override
    public <ValueType> ExperimentResult<ValueType> run(Experiment<ValueType> experiment) {
        ExperimentResult<ValueType> result = this.experimentEvaluatorEvaluator.evaluateExperiment(experiment, this.getEvaluationContext(), null);
        this.fireSubscriptions(experiment, result);
        return result;
    }

    @Override
    public void setOwnStickyBucketService(@Nullable StickyBucketService stickyBucketService) {
        this.context.setStickyBucketService(stickyBucketService);
        this.initializeEvalContext();
    }

    @Override
    public void setInMemoryStickyBucketService() {
        this.context.setStickyBucketService(new InMemoryStickyBucketServiceImpl(new HashMap<String, StickyAssignmentsDocument>()));
        this.initializeEvalContext();
    }

    @Override
    public Boolean isOn(String featureKey) {
        return this.featureEvaluator.evaluateFeature(featureKey, this.getEvaluationContext(), Object.class).isOn();
    }

    @Override
    public Boolean isOff(String featureKey) {
        return this.featureEvaluator.evaluateFeature(featureKey, this.getEvaluationContext(), Object.class).isOff();
    }

    @Override
    public Boolean getFeatureValue(String featureKey, Boolean defaultValue) {
        try {
            Boolean maybeValue = (Boolean)this.featureEvaluator.evaluateFeature(featureKey, this.getEvaluationContext(), Boolean.class).getValue();
            return maybeValue == null ? defaultValue : maybeValue;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public String getFeatureValue(String featureKey, String defaultValue) {
        try {
            String maybeValue = (String)this.featureEvaluator.evaluateFeature(featureKey, this.getEvaluationContext(), String.class).getValue();
            return maybeValue == null ? defaultValue : maybeValue;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public Float getFeatureValue(String featureKey, Float defaultValue) {
        try {
            Object maybeValue = this.featureEvaluator.evaluateFeature(featureKey, this.getEvaluationContext(), Object.class).getValue();
            if (maybeValue == null) {
                return defaultValue;
            }
            if (maybeValue instanceof Double) {
                return Float.valueOf(((Double)maybeValue).floatValue());
            }
            if (maybeValue instanceof Long) {
                return Float.valueOf(((Long)maybeValue).floatValue());
            }
            return defaultValue;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public Integer getFeatureValue(String featureKey, Integer defaultValue) {
        try {
            Object maybeValue = this.featureEvaluator.evaluateFeature(featureKey, this.getEvaluationContext(), Object.class).getValue();
            if (maybeValue == null) {
                return defaultValue;
            }
            if (maybeValue instanceof Double) {
                return ((Double)maybeValue).intValue();
            }
            if (maybeValue instanceof Long) {
                return ((Long)maybeValue).intValue();
            }
            return defaultValue;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public Object getFeatureValue(String featureKey, Object defaultValue) {
        try {
            Object maybeValue = this.featureEvaluator.evaluateFeature(featureKey, this.getEvaluationContext(), defaultValue.getClass()).getValue();
            return maybeValue == null ? defaultValue : maybeValue;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public <ValueType> ValueType getFeatureValue(String featureKey, ValueType defaultValue, Class<ValueType> gsonDeserializableClass) {
        try {
            Object maybeValue = this.featureEvaluator.evaluateFeature(featureKey, this.getEvaluationContext(), gsonDeserializableClass).getValue();
            if (maybeValue == null) {
                return defaultValue;
            }
            String stringValue = this.jsonUtils.gson.toJson(maybeValue);
            return (ValueType)this.jsonUtils.gson.fromJson(stringValue, gsonDeserializableClass);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public Boolean evaluateCondition(String attributesJsonString, String conditionJsonString) {
        try {
            JsonObject attributesJson = (JsonObject)this.jsonUtils.gson.fromJson(attributesJsonString, JsonObject.class);
            JsonObject conditionJson = (JsonObject)this.jsonUtils.gson.fromJson(conditionJsonString, JsonObject.class);
            JsonObject savedGroupsJson = (JsonObject)this.jsonUtils.gson.fromJson((JsonElement)this.savedGroups, JsonObject.class);
            return this.conditionEvaluator.evaluateCondition(attributesJson, conditionJson, savedGroupsJson);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public Double getFeatureValue(String featureKey, Double defaultValue) {
        try {
            Object maybeValue = this.featureEvaluator.evaluateFeature(featureKey, this.getEvaluationContext(), Object.class).getValue();
            if (maybeValue == null) {
                return defaultValue;
            }
            if (maybeValue instanceof Double) {
                return (Double)maybeValue;
            }
            if (maybeValue instanceof Long) {
                return ((Long)maybeValue).doubleValue();
            }
            return defaultValue;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    @Override
    public void destroy() {
        this.callbacks = new ArrayList<ExperimentRunCallback>();
    }

    @Override
    public void subscribe(ExperimentRunCallback callback) {
        this.callbacks.add(callback);
    }

    @Override
    public void featuresAPIModelSuccessfully(String featuresDataModel) {
        this.refreshStickyBucketService(featuresDataModel);
    }

    @Override
    public Boolean isFeatureEnabled(String featureKey) {
        if (this.context.getFeatures() != null) {
            return this.context.getFeatures().keySet().contains(featureKey);
        }
        return false;
    }

    private void refreshStickyBucketService(@Nullable String featuresDataModel) {
        if (this.context.getStickyBucketService() != null) {
            GrowthBookUtils.refreshStickyBuckets(this.context, featuresDataModel, this.attributeOverrides);
        }
    }

    private <ValueType> void fireSubscriptions(Experiment<ValueType> experiment, ExperimentResult<ValueType> result) {
        String key = experiment.getKey();
        AssignedExperiment prev = this.assigned.get(key);
        if (prev == null || !Objects.equals(prev.getInExperiment(), result.getInExperiment()) || !Objects.equals(prev.getVariationId(), result.getVariationId())) {
            AssignedExperiment current = new AssignedExperiment(experiment.getKey(), result.getInExperiment(), result.getVariationId());
            this.assigned.put(key, current);
            for (ExperimentRunCallback cb : this.callbacks) {
                try {
                    cb.onRun(experiment, result);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    public JsonObject getAttributeOverrides() {
        return this.attributeOverrides;
    }

    public void setAttributeOverrides(JsonObject attributeOverrides) {
        this.attributeOverrides = attributeOverrides;
    }

    public Map<String, Object> getForcedFeatureValues() {
        return this.forcedFeatureValues;
    }

    public void setForcedFeatureValues(Map<String, Object> forcedFeatureValues) {
        this.forcedFeatureValues = forcedFeatureValues;
    }
}

