/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.multiusermode;

import com.google.gson.JsonElement;
import growthbook.sdk.java.AssignedExperiment;
import growthbook.sdk.java.Experiment;
import growthbook.sdk.java.ExperimentEvaluator;
import growthbook.sdk.java.ExperimentResult;
import growthbook.sdk.java.ExperimentRunCallback;
import growthbook.sdk.java.FeatureEvaluator;
import growthbook.sdk.java.FeatureFetchException;
import growthbook.sdk.java.FeatureRefreshCallback;
import growthbook.sdk.java.FeatureResult;
import growthbook.sdk.java.GBFeaturesRepository;
import growthbook.sdk.java.GrowthBookJsonUtils;
import growthbook.sdk.java.RequestBodyForRemoteEval;
import growthbook.sdk.java.multiusermode.configurations.EvaluationContext;
import growthbook.sdk.java.multiusermode.configurations.GlobalContext;
import growthbook.sdk.java.multiusermode.configurations.Options;
import growthbook.sdk.java.multiusermode.configurations.UserContext;
import growthbook.sdk.java.multiusermode.util.TransformationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrowthBookClient {
    private static final Logger log = LoggerFactory.getLogger(GrowthBookClient.class);
    private final Options options;
    private final FeatureEvaluator featureEvaluator;
    private final ExperimentEvaluator experimentEvaluatorEvaluator;
    private static GBFeaturesRepository repository;
    private List<ExperimentRunCallback> callbacks;
    private final Map<String, AssignedExperiment> assigned;
    private GlobalContext globalContext;

    public GrowthBookClient() {
        this(Options.builder().build());
    }

    public GrowthBookClient(Options opts) {
        this.options = opts == null ? Options.builder().build() : opts;
        this.assigned = new HashMap<String, AssignedExperiment>();
        this.callbacks = new ArrayList<ExperimentRunCallback>();
        this.featureEvaluator = new FeatureEvaluator();
        this.experimentEvaluatorEvaluator = new ExperimentEvaluator();
        this.callbacks = new ArrayList<ExperimentRunCallback>();
    }

    public boolean initialize() {
        boolean isReady;
        block4: {
            isReady = false;
            try {
                if (repository != null) break block4;
                repository = GBFeaturesRepository.builder().apiHost(this.options.getApiHost()).clientKey(this.options.getClientKey()).decryptionKey(this.options.getDecryptionKey()).refreshStrategy(this.options.getRefreshStrategy()).isCacheDisabled(this.options.getIsCacheDisabled()).requestBodyForRemoteEval(this.configurePayloadForRemoteEval(this.options)).build();
                repository.onFeaturesRefresh(this.options.getFeatureRefreshCallback());
                repository.onFeaturesRefresh(this.refreshGlobalContext());
                try {
                    repository.initialize();
                }
                catch (FeatureFetchException e) {
                    log.error("Failed to initialize features repository", (Throwable)e);
                    throw new RuntimeException(e);
                }
                this.globalContext = GlobalContext.builder().features(TransformationUtil.transformFeatures(repository.getFeaturesJson())).savedGroups(TransformationUtil.transformSavedGroups(repository.getSavedGroupsJson())).enabled(this.options.getEnabled()).qaMode(this.options.getIsQaMode()).forcedFeatureValues(this.options.getGlobalForcedFeatureValues()).forcedVariations(this.options.getGlobalForcedVariationsMap()).build();
                isReady = repository.getInitialized();
            }
            catch (Exception e) {
                log.error("Failed to initialize growthbook instance", (Throwable)e);
            }
        }
        return isReady;
    }

    public void setGlobalAttributes(String attributes) {
        this.options.setGlobalAttributes(attributes);
    }

    public void setGlobalForceFeatures(Map<String, Object> forceFeatures) {
        this.options.setGlobalForcedFeatureValues(forceFeatures);
    }

    public void setGlobalForceVariations(Map<String, Integer> forceVariations) {
        this.options.setGlobalForcedVariationsMap(forceVariations);
    }

    public void refreshFeature() {
        try {
            repository.fetchFeatures();
        }
        catch (FeatureFetchException e) {
            log.error("Refreshing wasn't successful. Message is: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void refreshForRemoteEval(RequestBodyForRemoteEval requestBodyForRemoteEval) {
        try {
            repository.fetchForRemoteEval(requestBodyForRemoteEval);
        }
        catch (FeatureFetchException e) {
            log.error("Refreshing for remote eval wasn't successful. Message is: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public <ValueType> FeatureResult<ValueType> evalFeature(String key, Class<ValueType> valueTypeClass, UserContext userContext) {
        return this.featureEvaluator.evaluateFeature(key, this.getEvalContext(userContext), valueTypeClass);
    }

    public Boolean isOn(String featureKey, UserContext userContext) {
        return this.featureEvaluator.evaluateFeature(featureKey, this.getEvalContext(userContext), Object.class).isOn();
    }

    public Boolean isOff(String featureKey, UserContext userContext) {
        return this.featureEvaluator.evaluateFeature(featureKey, this.getEvalContext(userContext), Object.class).isOff();
    }

    public <ValueType> ValueType getFeatureValue(String featureKey, ValueType defaultValue, Class<ValueType> gsonDeserializableClass, UserContext userContext) {
        try {
            Object maybeValue = this.featureEvaluator.evaluateFeature(featureKey, this.getEvalContext(userContext), gsonDeserializableClass).getValue();
            if (maybeValue == null) {
                return defaultValue;
            }
            String stringValue = GrowthBookJsonUtils.getInstance().gson.toJson(maybeValue);
            return (ValueType)GrowthBookJsonUtils.getInstance().gson.fromJson(stringValue, gsonDeserializableClass);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public <ValueType> ExperimentResult<ValueType> run(Experiment<ValueType> experiment, UserContext userContext) {
        ExperimentResult<ValueType> result = this.experimentEvaluatorEvaluator.evaluateExperiment(experiment, this.getEvalContext(userContext), null);
        this.fireSubscriptions(experiment, result);
        return result;
    }

    public void subscribe(ExperimentRunCallback callback) {
        this.callbacks.add(callback);
    }

    private <ValueType> void fireSubscriptions(Experiment<ValueType> experiment, ExperimentResult<ValueType> result) {
        String key = experiment.getKey();
        AssignedExperiment prev = this.assigned.get(key);
        if (prev == null || !Objects.equals(prev.getInExperiment(), result.getInExperiment()) || !Objects.equals(prev.getVariationId(), result.getVariationId())) {
            AssignedExperiment current = new AssignedExperiment(experiment.getKey(), result.getInExperiment(), result.getVariationId());
            this.assigned.put(key, current);
            for (ExperimentRunCallback cb : this.callbacks) {
                try {
                    cb.onRun(experiment, result);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    private FeatureRefreshCallback refreshGlobalContext() {
        return new FeatureRefreshCallback(){

            @Override
            public void onRefresh(String featuresJson) {
                if (GrowthBookClient.this.globalContext != null) {
                    GrowthBookClient.this.globalContext.setFeatures(TransformationUtil.transformFeatures(featuresJson));
                    GrowthBookClient.this.globalContext.setSavedGroups(TransformationUtil.transformSavedGroups(repository.getSavedGroupsJson()));
                } else {
                    GrowthBookClient.this.globalContext = GlobalContext.builder().features(TransformationUtil.transformFeatures(featuresJson)).savedGroups(TransformationUtil.transformFeatures(repository.getSavedGroupsJson())).savedGroups(TransformationUtil.transformSavedGroups(repository.getSavedGroupsJson())).enabled(GrowthBookClient.this.options.getEnabled()).qaMode(GrowthBookClient.this.options.getIsQaMode()).forcedFeatureValues(GrowthBookClient.this.options.getGlobalForcedFeatureValues()).forcedVariations(GrowthBookClient.this.options.getGlobalForcedVariationsMap()).build();
                }
            }

            @Override
            public void onError(Throwable throwable) {
                log.warn("Unable to refresh global context with latest features", throwable);
            }
        };
    }

    private EvaluationContext getEvalContext(UserContext userContext) {
        HashMap globalAttributes = null;
        if (this.options.getGlobalAttributes() != null) {
            globalAttributes = (HashMap)GrowthBookJsonUtils.getInstance().gson.fromJson((JsonElement)this.options.getGlobalAttributes(), HashMap.class);
        }
        HashMap userAttributes = null;
        if (userContext.getAttributes() != null) {
            userAttributes = (HashMap)GrowthBookJsonUtils.getInstance().gson.fromJson((JsonElement)userContext.getAttributes(), HashMap.class);
        }
        if (globalAttributes != null) {
            if (userAttributes != null) {
                globalAttributes.putAll(userAttributes);
            }
        } else {
            globalAttributes = userAttributes;
        }
        String attributesJson = GrowthBookJsonUtils.getInstance().gson.toJson((Object)globalAttributes);
        userContext.setAttributesJson(attributesJson);
        return new EvaluationContext(this.globalContext, userContext, new EvaluationContext.StackContext(), this.options);
    }

    private RequestBodyForRemoteEval configurePayloadForRemoteEval(Options options) {
        List<List<Object>> forceFeaturesForPayload = new ArrayList<List<Object>>();
        if (options.getGlobalForcedFeatureValues() != null) {
            forceFeaturesForPayload = options.getGlobalForcedFeatureValues().entrySet().stream().map(entry -> Arrays.asList(entry.getKey(), entry.getValue())).collect(Collectors.toList());
        }
        return new RequestBodyForRemoteEval(options.getGlobalAttributes(), forceFeaturesForPayload, options.getGlobalForcedVariationsMap(), options.getUrl());
    }
}

