/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.BucketRange;
import growthbook.sdk.java.ConditionEvaluator;
import growthbook.sdk.java.Experiment;
import growthbook.sdk.java.ExperimentResult;
import growthbook.sdk.java.FeatureEvaluator;
import growthbook.sdk.java.FeatureResult;
import growthbook.sdk.java.FeatureResultSource;
import growthbook.sdk.java.Filter;
import growthbook.sdk.java.GBContext;
import growthbook.sdk.java.GeneratedStickyBucketAssignmentDocModel;
import growthbook.sdk.java.GrowthBookJsonUtils;
import growthbook.sdk.java.GrowthBookUtils;
import growthbook.sdk.java.HashAttributeAndHashValue;
import growthbook.sdk.java.IExperimentEvaluator;
import growthbook.sdk.java.Namespace;
import growthbook.sdk.java.ParentCondition;
import growthbook.sdk.java.StickyBucketVariation;
import growthbook.sdk.java.TrackingCallback;
import growthbook.sdk.java.VariationMeta;
import growthbook.sdk.java.stickyBucketing.StickyAssignmentsDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExperimentEvaluator
implements IExperimentEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ExperimentEvaluator.class);
    private final ConditionEvaluator conditionEvaluator = new ConditionEvaluator();
    private final GrowthBookJsonUtils jsonUtils = GrowthBookJsonUtils.getInstance();

    ExperimentEvaluator() {
    }

    @Override
    public <ValueType> ExperimentResult<ValueType> evaluateExperiment(Experiment<ValueType> experiment, GBContext context, @Nullable String featureId, JsonObject attributeOverrides) {
        TrackingCallback trackingCallback;
        Float hash;
        Integer hashVersion;
        String seed;
        JsonObject attributes;
        HashAttributeAndHashValue hashAttribute;
        Integer forcedVariation;
        ArrayList<Object> experimentVariations = experiment.getVariations();
        if (experimentVariations == null) {
            experimentVariations = new ArrayList();
        }
        if (context.getEnabled() != null && !context.getEnabled().booleanValue() || experimentVariations.size() < 2) {
            return this.getExperimentResult(context, experiment, -1, false, featureId, null, null, attributeOverrides);
        }
        Integer override = GrowthBookUtils.getQueryStringOverride(experiment.getKey(), context.getUrl(), (Integer)experimentVariations.size());
        if (override != null) {
            return this.getExperimentResult(context, experiment, override, false, featureId, null, null, attributeOverrides);
        }
        Map<String, Integer> forcedVariations = context.getForcedVariationsMap();
        if (forcedVariations == null) {
            forcedVariations = new HashMap<String, Integer>();
        }
        if ((forcedVariation = forcedVariations.get(experiment.getKey())) != null) {
            return this.getExperimentResult(context, experiment, forcedVariation, false, featureId, null, null, attributeOverrides);
        }
        if (experiment.getIsActive() != null && !experiment.getIsActive().booleanValue()) {
            return this.getExperimentResult(context, experiment, -1, false, featureId, null, null, attributeOverrides);
        }
        String fallBack = null;
        if (context.getStickyBucketService() != null && !Boolean.TRUE.equals(experiment.disableStickyBucketing)) {
            fallBack = experiment.getFallbackAttribute();
        }
        if ((hashAttribute = GrowthBookUtils.getHashAttribute(context, experiment.getHashAttribute(), fallBack, attributeOverrides)).getHashValue().isEmpty() || hashAttribute.getHashValue().equals("null")) {
            return this.getExperimentResult(context, experiment, -1, false, featureId, null, null, attributeOverrides);
        }
        int assigned = -1;
        boolean foundStickyBucket = false;
        boolean stickyBucketVersionIsBlocked = false;
        if (context.getStickyBucketService() != null && !Boolean.TRUE.equals(experiment.disableStickyBucketing)) {
            int bucketVersion = experiment.getBucketVersion() != null ? experiment.getBucketVersion() : 0;
            int minBucketVersion = experiment.getMinBucketVersion() != null ? experiment.getMinBucketVersion() : 0;
            ArrayList<VariationMeta> meta = experiment.getMeta() != null ? experiment.getMeta() : new ArrayList<VariationMeta>();
            StickyBucketVariation stickyBucketVariation = GrowthBookUtils.getStickyBucketVariation(context, experiment.getKey(), experiment.getHashAttribute(), experiment.getFallbackAttribute(), attributeOverrides, bucketVersion, minBucketVersion, meta);
            foundStickyBucket = stickyBucketVariation.getVariation() >= 0;
            assigned = stickyBucketVariation.getVariation();
            boolean bl = stickyBucketVersionIsBlocked = stickyBucketVariation.getVersionIsBlocked() != null ? stickyBucketVariation.getVersionIsBlocked() : false;
        }
        if ((attributes = context.getAttributes()) == null) {
            attributes = new JsonObject();
        }
        if (!foundStickyBucket) {
            Boolean shouldEvaluate;
            Boolean isInNamespace;
            ArrayList<Filter> filters = experiment.getFilters();
            Namespace namespace = experiment.getNamespace();
            if (filters != null ? GrowthBookUtils.isFilteredOut(filters, attributeOverrides, context) != false : namespace != null && (isInNamespace = GrowthBookUtils.inNameSpace(hashAttribute.getHashValue(), namespace)) == false) {
                return this.getExperimentResult(context, experiment, -1, false, featureId, null, null, attributeOverrides);
            }
            JsonObject conditionJson = experiment.getConditionJson();
            if (conditionJson != null && !(shouldEvaluate = this.conditionEvaluator.evaluateCondition(attributes, conditionJson, context.getSavedGroups())).booleanValue()) {
                return this.getExperimentResult(context, experiment, -1, false, featureId, null, null, attributeOverrides);
            }
            ArrayList<ParentCondition> parenConditions = experiment.getParentConditions();
            if (parenConditions != null) {
                for (ParentCondition parentCondition : parenConditions) {
                    JsonObject attributesJson;
                    boolean evalCondition;
                    FeatureResult parentResult = new FeatureEvaluator().evaluateFeature(parentCondition.getId(), context, null, (JsonObject)this.jsonUtils.gson.fromJson((JsonElement)parentCondition.getCondition(), JsonObject.class));
                    if (parentResult.getSource() != null && parentResult.getSource().equals((Object)FeatureResultSource.CYCLIC_PREREQUISITE)) {
                        return this.getExperimentResult(context, experiment, -1, false, featureId, null, null, attributeOverrides);
                    }
                    HashMap<String, Object> evalObj = new HashMap<String, Object>();
                    if (parentResult.getValue() != null) {
                        evalObj.put("value", parentResult.getValue());
                    }
                    if (evalCondition = this.conditionEvaluator.evaluateCondition(attributesJson = GrowthBookJsonUtils.getInstance().gson.toJsonTree(evalObj).getAsJsonObject(), parentCondition.getCondition(), context.getSavedGroups()).booleanValue()) continue;
                    log.info("Feature blocked by prerequisite");
                    return this.getExperimentResult(context, experiment, -1, false, featureId, null, null, attributeOverrides);
                }
            }
        }
        if ((seed = experiment.getSeed()) == null) {
            seed = experiment.getKey();
        }
        if ((hashVersion = experiment.getHashVersion()) == null) {
            hashVersion = 1;
        }
        if ((hash = GrowthBookUtils.hash(hashAttribute.getHashValue(), hashVersion, seed)) == null) {
            return this.getExperimentResult(context, experiment, -1, false, featureId, null, null, attributeOverrides);
        }
        if (!foundStickyBucket) {
            ArrayList<BucketRange> bucketRanges;
            Float coverage;
            ArrayList<Float> weights = experiment.getWeights();
            if (weights == null) {
                weights = GrowthBookUtils.getEqualWeights(experiment.getVariations().size());
            }
            if ((coverage = experiment.getCoverage()) == null) {
                coverage = Float.valueOf(1.0f);
            }
            if ((bucketRanges = experiment.getRanges()) == null) {
                bucketRanges = GrowthBookUtils.getBucketRanges(experiment.getVariations().size(), coverage, weights);
            }
            assigned = GrowthBookUtils.chooseVariation(hash, bucketRanges);
        }
        if (stickyBucketVersionIsBlocked) {
            return this.getExperimentResult(context, experiment, -1, false, featureId, null, true, attributeOverrides);
        }
        if (assigned < 0) {
            return this.getExperimentResult(context, experiment, -1, false, featureId, null, null, attributeOverrides);
        }
        Integer force = experiment.getForce();
        if (force != null) {
            return this.getExperimentResult(context, experiment, force, false, featureId, null, null, attributeOverrides);
        }
        if (context.getIsQaMode() != null && context.getIsQaMode().booleanValue()) {
            return this.getExperimentResult(context, experiment, -1, false, featureId, null, null, attributeOverrides);
        }
        ExperimentResult<ValueType> result = this.getExperimentResult(context, experiment, assigned, true, featureId, hash, foundStickyBucket, attributeOverrides);
        if (context.getStickyBucketService() != null && !Boolean.TRUE.equals(experiment.disableStickyBucketing)) {
            HashMap<String, String> assignments = new HashMap<String, String>();
            assignments.put(GrowthBookUtils.getStickyBucketExperimentKey(experiment.getKey(), experiment.getBucketVersion()), result.getKey());
            GeneratedStickyBucketAssignmentDocModel generatedStickyBucketAssignmentDocModel = GrowthBookUtils.generateStickyBucketAssignmentDoc(context, hashAttribute.getHashAttribute(), hashAttribute.getHashValue(), assignments);
            if (generatedStickyBucketAssignmentDocModel.isChanged()) {
                if (context.getStickyBucketAssignmentDocs() == null) {
                    context.setStickyBucketAssignmentDocs(new HashMap<String, StickyAssignmentsDocument>());
                }
                context.getStickyBucketAssignmentDocs().put(generatedStickyBucketAssignmentDocModel.getKey(), generatedStickyBucketAssignmentDocModel.getStickyAssignmentsDocument());
                context.getStickyBucketService().saveAssignments(generatedStickyBucketAssignmentDocModel.getStickyAssignmentsDocument());
            }
        }
        if (!context.getExperimentHelper().isTracked(experiment, result) && (trackingCallback = context.getTrackingCallback()) != null) {
            trackingCallback.onTrack(experiment, result);
        }
        return result;
    }

    private <ValueType> ExperimentResult<ValueType> getExperimentResult(GBContext context, Experiment<ValueType> experiment, Integer variationIndex, Boolean hashUsed, String featureId, @Nullable Float hashBucket, @Nullable Boolean stickyBucketUsed, JsonObject attributeOverrides) {
        boolean inExperiment = true;
        Integer targetVariationIndex = variationIndex;
        ArrayList<Object> experimentVariations = experiment.getVariations();
        if (experimentVariations == null) {
            experimentVariations = new ArrayList();
        }
        if (targetVariationIndex < 0 || targetVariationIndex >= experimentVariations.size()) {
            targetVariationIndex = 0;
            inExperiment = false;
        }
        String fallBack = null;
        if (context.getStickyBucketService() != null && !Boolean.TRUE.equals(experiment.disableStickyBucketing)) {
            fallBack = experiment.getFallbackAttribute();
        }
        HashAttributeAndHashValue hashAttribute = GrowthBookUtils.getHashAttribute(context, experiment.getHashAttribute(), fallBack, attributeOverrides);
        ArrayList<Object> experimentMeta = new ArrayList();
        if (experiment.meta != null) {
            experimentMeta = experiment.meta;
        }
        VariationMeta meta = null;
        if (experimentMeta.size() > targetVariationIndex) {
            meta = (VariationMeta)experimentMeta.get(targetVariationIndex);
        }
        String key = meta != null ? meta.getKey() : targetVariationIndex + "";
        String name = meta != null ? meta.getName() : null;
        Boolean passThrough = meta != null ? meta.getPassThrough() : null;
        Object targetValue = null;
        if (experiment.variations.size() > targetVariationIndex) {
            targetValue = experiment.variations.get(targetVariationIndex);
        }
        return ExperimentResult.builder().inExperiment(inExperiment).variationId(variationIndex).value(targetValue).hashAttribute(hashAttribute.getHashAttribute()).hashValue(hashAttribute.getHashValue()).key(key).featureId(featureId).hashUsed(hashUsed).stickyBucketUsed(stickyBucketUsed != null ? stickyBucketUsed : false).name(name).bucket(hashBucket).passThrough(passThrough).build();
    }
}

