/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DecryptionUtils {
    private static final Logger log = LoggerFactory.getLogger(DecryptionUtils.class);

    DecryptionUtils() {
    }

    public static String decrypt(String payload, String encryptionKey) throws DecryptionException {
        if (!payload.contains(".")) {
            log.error("DecryptionException: Invalid payload");
            throw new DecryptionException("Invalid payload");
        }
        try {
            String[] parts = payload.split("\\.");
            String iv = parts[0];
            String cipherText = parts[1];
            byte[] decodedIv = Base64.getDecoder().decode(iv.getBytes(StandardCharsets.UTF_8));
            IvParameterSpec ivParameterSpec = new IvParameterSpec(decodedIv);
            Cipher cipher = Cipher.getInstance("AES/CBC/NOPADDING");
            cipher.init(2, (Key)DecryptionUtils.keyFromSecret(encryptionKey), ivParameterSpec);
            byte[] decodedCipher = Base64.getDecoder().decode(cipherText.getBytes(StandardCharsets.UTF_8));
            byte[] plainText = cipher.doFinal(decodedCipher);
            StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(plainText));
            return new String(plainText);
        }
        catch (InvalidAlgorithmParameterException e) {
            log.error("DecryptionException: Invalid payload", (Throwable)e);
            throw new DecryptionException("Invalid payload");
        }
        catch (InvalidKeyException e) {
            log.error("DecryptionException: Invalid encryption key", (Throwable)e);
            throw new DecryptionException("Invalid encryption key");
        }
        catch (IllegalArgumentException | CharacterCodingException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DecryptionException(e.getMessage());
        }
    }

    private static SecretKeySpec keyFromSecret(String encryptionKey) {
        byte[] encodedKeyBytes = encryptionKey.getBytes(StandardCharsets.UTF_8);
        byte[] keyBytes = Base64.getDecoder().decode(encodedKeyBytes);
        return new SecretKeySpec(keyBytes, "AES");
    }

    public static class DecryptionException
    extends Exception {
        public DecryptionException(String errorMessage) {
            super(errorMessage);
        }
    }
}

