/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import growthbook.sdk.java.DataType;
import growthbook.sdk.java.GrowthBookJsonUtils;
import growthbook.sdk.java.IConditionEvaluator;
import growthbook.sdk.java.Operator;
import growthbook.sdk.java.StringUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

class ConditionEvaluator
implements IConditionEvaluator {
    private final GrowthBookJsonUtils jsonUtils = GrowthBookJsonUtils.getInstance();

    ConditionEvaluator() {
    }

    @Override
    public Boolean evaluateCondition(String attributesJsonString, String conditionJsonString) {
        try {
            JsonElement attributesJson = (JsonElement)this.jsonUtils.gson.fromJson(attributesJsonString, JsonElement.class);
            JsonObject conditionJson = (JsonObject)this.jsonUtils.gson.fromJson(conditionJsonString, JsonObject.class);
            if (conditionJson.has("$or")) {
                JsonArray targetItems = conditionJson.get("$or").getAsJsonArray();
                return this.evalOr(attributesJson, targetItems);
            }
            if (conditionJson.has("$nor")) {
                JsonArray targetItems = conditionJson.get("$nor").getAsJsonArray();
                return this.evalOr(attributesJson, targetItems) == false;
            }
            if (conditionJson.has("$and")) {
                JsonArray targetItems = conditionJson.get("$and").getAsJsonArray();
                return this.evalAnd(attributesJson, targetItems);
            }
            if (conditionJson.has("$not")) {
                JsonElement targetItem = conditionJson.get("$not");
                return this.evaluateCondition(attributesJsonString, targetItem.toString()) == false;
            }
            Set conditionEntries = conditionJson.entrySet();
            for (Map.Entry entry : conditionEntries) {
                JsonElement element = (JsonElement)this.getPath(attributesJson, (String)entry.getKey());
                if (entry.getValue() == null || this.evalConditionValue((JsonElement)entry.getValue(), element).booleanValue()) continue;
                return false;
            }
            return true;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return false;
        }
    }

    Boolean isOperatorObject(JsonElement object) {
        if (!object.isJsonObject()) {
            return false;
        }
        Set entries = ((JsonObject)object).entrySet();
        if (entries.size() == 0) {
            return true;
        }
        long without$Prefix = entries.stream().filter(o -> !((String)o.getKey()).startsWith("$")).count();
        return without$Prefix == 0L;
    }

    @Nullable
    Object getPath(JsonElement attributes, String path) {
        if (Objects.equals(path, "")) {
            return null;
        }
        ArrayList<String> paths = new ArrayList<String>();
        if (path.contains(".")) {
            String[] pathSegments = path.split("\\.");
            Collections.addAll(paths, pathSegments);
        } else {
            paths.add(path);
        }
        JsonElement element = attributes;
        for (String segment : paths) {
            if (element == null || element instanceof JsonArray) {
                return null;
            }
            if (element instanceof JsonObject) {
                element = ((JsonObject)element).get(segment);
                continue;
            }
            return null;
        }
        return element;
    }

    Boolean evalOperatorCondition(String operatorString, @Nullable JsonElement actual, JsonElement expected) {
        Operator operator = Operator.fromString(operatorString);
        if (operator == null) {
            return false;
        }
        DataType attributeDataType = GrowthBookJsonUtils.getElementType(actual);
        switch (operator) {
            case IN: {
                if (actual == null) {
                    return false;
                }
                if (DataType.ARRAY == attributeDataType) {
                    if (!expected.isJsonArray()) {
                        return false;
                    }
                    JsonArray value = actual.getAsJsonArray();
                    JsonArray expectedArr = expected.getAsJsonArray();
                    return this.isIn((JsonElement)value, expectedArr);
                }
                if (DataType.STRING == attributeDataType) {
                    String value = actual.getAsString();
                    Type listType = new TypeToken<ArrayList<String>>(){}.getType();
                    ArrayList conditionsList = (ArrayList)this.jsonUtils.gson.fromJson(expected, listType);
                    return conditionsList.contains(value);
                }
                if (DataType.NUMBER == attributeDataType) {
                    Float value = Float.valueOf(actual.getAsFloat());
                    Type listType = new TypeToken<ArrayList<Float>>(){}.getType();
                    ArrayList conditionsList = (ArrayList)this.jsonUtils.gson.fromJson(expected, listType);
                    return conditionsList.contains(value);
                }
                if (DataType.BOOLEAN == attributeDataType) {
                    Boolean value = actual.getAsBoolean();
                    Type listType = new TypeToken<ArrayList<Boolean>>(){}.getType();
                    ArrayList conditionsList = (ArrayList)this.jsonUtils.gson.fromJson(expected, listType);
                    return conditionsList.contains(value);
                }
            }
            case NIN: {
                if (actual == null) {
                    return false;
                }
                if (DataType.ARRAY == attributeDataType) {
                    JsonArray expectedArr;
                    if (!expected.isJsonArray()) {
                        return false;
                    }
                    JsonArray value = actual.getAsJsonArray();
                    return this.isIn((JsonElement)value, expectedArr = expected.getAsJsonArray()) == false;
                }
                if (DataType.STRING == attributeDataType) {
                    String value = actual.getAsString();
                    Type listType = new TypeToken<ArrayList<String>>(){}.getType();
                    ArrayList conditionsList = (ArrayList)this.jsonUtils.gson.fromJson(expected, listType);
                    return !conditionsList.contains(value);
                }
                if (DataType.NUMBER == attributeDataType) {
                    Float value = Float.valueOf(actual.getAsFloat());
                    Type listType = new TypeToken<ArrayList<Float>>(){}.getType();
                    ArrayList conditionsList = (ArrayList)this.jsonUtils.gson.fromJson(expected, listType);
                    return !conditionsList.contains(value);
                }
                if (DataType.BOOLEAN == attributeDataType) {
                    Boolean value = actual.getAsBoolean();
                    Type listType = new TypeToken<ArrayList<Boolean>>(){}.getType();
                    ArrayList conditionsList = (ArrayList)this.jsonUtils.gson.fromJson(expected, listType);
                    return !conditionsList.contains(value);
                }
            }
            case GT: {
                if (actual == null) {
                    return false;
                }
                if (actual.getAsJsonPrimitive().isNumber()) {
                    return actual.getAsNumber().floatValue() > expected.getAsNumber().floatValue();
                }
                if (actual.getAsJsonPrimitive().isString()) {
                    return actual.getAsString().compareTo(expected.getAsString()) > 0;
                }
            }
            case GTE: {
                if (actual == null) {
                    return false;
                }
                if (actual.getAsJsonPrimitive().isNumber()) {
                    return actual.getAsNumber().floatValue() >= expected.getAsNumber().floatValue();
                }
                if (actual.getAsJsonPrimitive().isString()) {
                    return actual.getAsString().compareTo(expected.getAsString()) >= 0;
                }
            }
            case LT: {
                if (actual == null) {
                    return false;
                }
                if (actual.getAsJsonPrimitive().isNumber()) {
                    return actual.getAsNumber().floatValue() < expected.getAsNumber().floatValue();
                }
                if (actual.getAsJsonPrimitive().isString()) {
                    return actual.getAsString().compareTo(expected.getAsString()) < 0;
                }
            }
            case LTE: {
                if (actual == null) {
                    return false;
                }
                if (actual.getAsJsonPrimitive().isNumber()) {
                    return actual.getAsNumber().floatValue() <= expected.getAsNumber().floatValue();
                }
                if (actual.getAsJsonPrimitive().isString()) {
                    return actual.getAsString().compareTo(expected.getAsString()) <= 0;
                }
            }
            case REGEX: {
                if (actual == null) {
                    return false;
                }
                Pattern pattern = Pattern.compile(expected.getAsString());
                Matcher matcher = pattern.matcher(actual.getAsString());
                boolean matches = false;
                while (matcher.find()) {
                    matches = true;
                }
                return matches;
            }
            case NE: {
                if (actual == null) {
                    return false;
                }
                return this.arePrimitivesEqual(actual.getAsJsonPrimitive(), expected.getAsJsonPrimitive(), attributeDataType) == false;
            }
            case EQ: {
                if (actual == null) {
                    return false;
                }
                return this.arePrimitivesEqual(actual.getAsJsonPrimitive(), expected.getAsJsonPrimitive(), attributeDataType);
            }
            case SIZE: {
                if (actual == null || !actual.isJsonArray()) {
                    return false;
                }
                JsonArray attributeValueArrayForSize = (JsonArray)actual;
                JsonPrimitive size = new JsonPrimitive((Number)attributeValueArrayForSize.size());
                return this.evalConditionValue(expected, (JsonElement)size);
            }
            case ELEMENT_MATCH: {
                if (actual == null) {
                    return false;
                }
                return this.elemMatch(actual, expected);
            }
            case ALL: {
                if (actual == null || !actual.isJsonArray()) {
                    return false;
                }
                JsonArray actualArrayForAll = (JsonArray)actual;
                JsonArray expectedArrayForAll = (JsonArray)expected;
                for (int i = 0; i < expectedArrayForAll.size(); ++i) {
                    boolean passed = false;
                    for (int j = 0; j < actualArrayForAll.size(); ++j) {
                        if (!this.evalConditionValue(expectedArrayForAll.get(i), actualArrayForAll.get(j)).booleanValue()) continue;
                        passed = true;
                        break;
                    }
                    if (passed) continue;
                    return false;
                }
            }
            case NOT: {
                return this.evalConditionValue(expected, actual) == false;
            }
            case TYPE: {
                return GrowthBookJsonUtils.getElementType(actual).toString().equals(expected.getAsString());
            }
            case EXISTS: {
                boolean exists = expected.getAsBoolean();
                if (exists) {
                    return actual != null;
                }
                return actual == null || actual.isJsonNull();
            }
            case VERSION_GT: {
                if (actual == null || expected == null) {
                    return false;
                }
                return StringUtils.paddedVersionString(actual.getAsString()).compareTo(StringUtils.paddedVersionString(expected.getAsString())) > 0;
            }
            case VERSION_GTE: {
                if (actual == null || expected == null) {
                    return false;
                }
                return StringUtils.paddedVersionString(actual.getAsString()).compareTo(StringUtils.paddedVersionString(expected.getAsString())) >= 0;
            }
            case VERSION_LT: {
                if (actual == null || expected == null) {
                    return false;
                }
                return StringUtils.paddedVersionString(actual.getAsString()).compareTo(StringUtils.paddedVersionString(expected.getAsString())) < 0;
            }
            case VERSION_LTE: {
                if (actual == null || expected == null) {
                    return false;
                }
                return StringUtils.paddedVersionString(actual.getAsString()).compareTo(StringUtils.paddedVersionString(expected.getAsString())) <= 0;
            }
            case VERSION_NE: {
                if (actual == null || expected == null) {
                    return false;
                }
                return StringUtils.paddedVersionString(actual.getAsString()).compareTo(StringUtils.paddedVersionString(expected.getAsString())) != 0;
            }
            case VERSION_EQ: {
                if (actual == null || expected == null) {
                    return false;
                }
                return StringUtils.paddedVersionString(actual.getAsString()).compareTo(StringUtils.paddedVersionString(expected.getAsString())) == 0;
            }
        }
        return false;
    }

    Boolean arePrimitivesEqual(JsonPrimitive a, JsonPrimitive b, DataType dataType) {
        switch (dataType) {
            case STRING: {
                return a.getAsString().equals(b.getAsString());
            }
            case NUMBER: {
                return Objects.equals(a.getAsNumber(), b.getAsNumber());
            }
            case BOOLEAN: {
                return a.getAsBoolean() == b.getAsBoolean();
            }
        }
        System.out.printf("\nUnsupported data type %s", new Object[]{dataType});
        return false;
    }

    Boolean evalConditionValue(JsonElement conditionValue, @Nullable JsonElement attributeValue) {
        JsonObject conditionValueObject;
        if (conditionValue.isJsonObject() && this.isOperatorObject((JsonElement)(conditionValueObject = (JsonObject)conditionValue)).booleanValue()) {
            Set entries = conditionValueObject.entrySet();
            for (Map.Entry entry : entries) {
                if (this.evalOperatorCondition((String)entry.getKey(), attributeValue, (JsonElement)entry.getValue()).booleanValue()) continue;
                return false;
            }
            return true;
        }
        if (conditionValue.isJsonNull() && (attributeValue == null || attributeValue.isJsonNull())) {
            return true;
        }
        if (attributeValue == null) {
            return false;
        }
        return conditionValue.toString().equals(attributeValue.toString());
    }

    Boolean elemMatch(JsonElement actual, JsonElement expected) {
        if (!actual.isJsonArray()) {
            return false;
        }
        JsonArray actualArray = actual.getAsJsonArray();
        boolean isOperator = this.isOperatorObject(expected);
        for (JsonElement actualElement : actualArray) {
            if (!(isOperator ? this.evalConditionValue(expected, actualElement) != false : this.evaluateCondition(actualElement.toString(), expected.toString()) != false)) continue;
            return true;
        }
        return false;
    }

    Boolean evalOr(JsonElement attributes, JsonArray conditions) {
        if (conditions.size() == 0) {
            return true;
        }
        Iterator iterator = conditions.iterator();
        while (iterator.hasNext()) {
            JsonElement condition;
            String attributesString = attributes == null ? "{}" : attributes.toString();
            Boolean matches = this.evaluateCondition(attributesString, (condition = (JsonElement)iterator.next()).toString());
            if (!matches.booleanValue()) continue;
            return true;
        }
        return false;
    }

    Boolean evalAnd(JsonElement attributes, JsonArray conditions) {
        Iterator iterator = conditions.iterator();
        while (iterator.hasNext()) {
            JsonElement condition;
            String attributesString = attributes == null ? "{}" : attributes.toString();
            Boolean matches = this.evaluateCondition(attributesString, (condition = (JsonElement)iterator.next()).toString());
            if (matches.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private Boolean isIn(JsonElement actual, JsonArray expected) {
        Type listType = new TypeToken<ArrayList<Object>>(){}.getType();
        ArrayList expectedAsList = (ArrayList)this.jsonUtils.gson.fromJson((JsonElement)expected, listType);
        if (!actual.isJsonArray()) {
            return expectedAsList.contains(actual);
        }
        JsonArray actualArr = actual.getAsJsonArray();
        if (actualArr.size() == 0) {
            return false;
        }
        DataType attributeDataType = GrowthBookJsonUtils.getElementType(actualArr.get(0));
        ArrayList actualAsList = (ArrayList)this.jsonUtils.gson.fromJson((JsonElement)actualArr, listType);
        return actualAsList.stream().anyMatch(o -> {
            if (attributeDataType == DataType.STRING || attributeDataType == DataType.NUMBER || attributeDataType == DataType.BOOLEAN) {
                return expectedAsList.contains(o);
            }
            return false;
        });
    }
}

