/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import growthbook.sdk.java.Experiment;
import growthbook.sdk.java.ExperimentResult;
import growthbook.sdk.java.FeatureResultSource;
import growthbook.sdk.java.GrowthBookJsonUtils;
import java.lang.reflect.Type;
import javax.annotation.Nullable;

public class FeatureResult<ValueType> {
    @Nullable
    @SerializedName(value="value")
    Object value;
    @Nullable
    FeatureResultSource source;
    @Nullable
    Experiment<ValueType> experiment;
    @Nullable
    ExperimentResult<ValueType> experimentResult;
    @Nullable
    String ruleId;

    public String toJson() {
        return FeatureResult.getJson(this).toString();
    }

    public Boolean isOn() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        if (this.value instanceof String) {
            return !((String)this.value).isEmpty();
        }
        if (this.value instanceof Integer) {
            return (Integer)this.value != 0;
        }
        if (this.value instanceof Float) {
            return ((Float)this.value).floatValue() != 0.0f;
        }
        return false;
    }

    public Boolean isOff() {
        return this.isOn() == false;
    }

    public static <ValueType> JsonElement getJson(FeatureResult<ValueType> object) {
        JsonObject jsonObject = new JsonObject();
        JsonPrimitive isOn = new JsonPrimitive(object.isOn());
        JsonPrimitive isOff = new JsonPrimitive(object.isOff());
        jsonObject.add("on", (JsonElement)isOn);
        jsonObject.add("off", (JsonElement)isOff);
        Object value = object.getValue();
        JsonElement valueElement = GrowthBookJsonUtils.getInstance().gson.toJsonTree(value);
        jsonObject.add("value", valueElement);
        Experiment<ValueType> experiment = object.getExperiment();
        JsonElement experimentElement = GrowthBookJsonUtils.getInstance().gson.toJsonTree(experiment);
        jsonObject.add("experiment", experimentElement);
        ExperimentResult<ValueType> experimentResult = object.getExperimentResult();
        JsonElement experimentResultElement = GrowthBookJsonUtils.getInstance().gson.toJsonTree(experimentResult);
        jsonObject.add("experimentResult", experimentResultElement);
        FeatureResultSource source = object.getSource();
        if (source != null) {
            JsonPrimitive jsonSource = new JsonPrimitive(source.toString());
            jsonObject.add("source", (JsonElement)jsonSource);
        }
        return jsonObject;
    }

    public static <ValueType> JsonSerializer<FeatureResult<ValueType>> getSerializer() {
        return new JsonSerializer<FeatureResult<ValueType>>(){

            public JsonElement serialize(FeatureResult<ValueType> src, Type typeOfSrc, JsonSerializationContext context) {
                return FeatureResult.getJson(src);
            }
        };
    }

    public static <ValueType> FeatureResultBuilder<ValueType> builder() {
        return new FeatureResultBuilder();
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Nullable
    public FeatureResultSource getSource() {
        return this.source;
    }

    @Nullable
    public Experiment<ValueType> getExperiment() {
        return this.experiment;
    }

    @Nullable
    public ExperimentResult<ValueType> getExperimentResult() {
        return this.experimentResult;
    }

    @Nullable
    public String getRuleId() {
        return this.ruleId;
    }

    public void setValue(@Nullable Object value) {
        this.value = value;
    }

    public void setSource(@Nullable FeatureResultSource source) {
        this.source = source;
    }

    public void setExperiment(@Nullable Experiment<ValueType> experiment) {
        this.experiment = experiment;
    }

    public void setExperimentResult(@Nullable ExperimentResult<ValueType> experimentResult) {
        this.experimentResult = experimentResult;
    }

    public void setRuleId(@Nullable String ruleId) {
        this.ruleId = ruleId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureResult)) {
            return false;
        }
        FeatureResult other = (FeatureResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        FeatureResultSource this$source = this.getSource();
        FeatureResultSource other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)((Object)this$source)).equals((Object)other$source)) {
            return false;
        }
        Experiment<ValueType> this$experiment = this.getExperiment();
        Experiment<ValueType> other$experiment = other.getExperiment();
        if (this$experiment == null ? other$experiment != null : !((Object)this$experiment).equals(other$experiment)) {
            return false;
        }
        ExperimentResult<ValueType> this$experimentResult = this.getExperimentResult();
        ExperimentResult<ValueType> other$experimentResult = other.getExperimentResult();
        if (this$experimentResult == null ? other$experimentResult != null : !((Object)this$experimentResult).equals(other$experimentResult)) {
            return false;
        }
        String this$ruleId = this.getRuleId();
        String other$ruleId = other.getRuleId();
        return !(this$ruleId == null ? other$ruleId != null : !this$ruleId.equals(other$ruleId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeatureResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        FeatureResultSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)((Object)$source)).hashCode());
        Experiment<ValueType> $experiment = this.getExperiment();
        result = result * 59 + ($experiment == null ? 43 : ((Object)$experiment).hashCode());
        ExperimentResult<ValueType> $experimentResult = this.getExperimentResult();
        result = result * 59 + ($experimentResult == null ? 43 : ((Object)$experimentResult).hashCode());
        String $ruleId = this.getRuleId();
        result = result * 59 + ($ruleId == null ? 43 : $ruleId.hashCode());
        return result;
    }

    public String toString() {
        return "FeatureResult(value=" + this.getValue() + ", source=" + (Object)((Object)this.getSource()) + ", experiment=" + this.getExperiment() + ", experimentResult=" + this.getExperimentResult() + ", ruleId=" + this.getRuleId() + ")";
    }

    public FeatureResult(@Nullable Object value, @Nullable FeatureResultSource source, @Nullable Experiment<ValueType> experiment, @Nullable ExperimentResult<ValueType> experimentResult, @Nullable String ruleId) {
        this.value = value;
        this.source = source;
        this.experiment = experiment;
        this.experimentResult = experimentResult;
        this.ruleId = ruleId;
    }

    public static class FeatureResultBuilder<ValueType> {
        private Object value;
        private FeatureResultSource source;
        private Experiment<ValueType> experiment;
        private ExperimentResult<ValueType> experimentResult;
        private String ruleId;

        FeatureResultBuilder() {
        }

        public FeatureResultBuilder<ValueType> value(@Nullable Object value) {
            this.value = value;
            return this;
        }

        public FeatureResultBuilder<ValueType> source(@Nullable FeatureResultSource source) {
            this.source = source;
            return this;
        }

        public FeatureResultBuilder<ValueType> experiment(@Nullable Experiment<ValueType> experiment) {
            this.experiment = experiment;
            return this;
        }

        public FeatureResultBuilder<ValueType> experimentResult(@Nullable ExperimentResult<ValueType> experimentResult) {
            this.experimentResult = experimentResult;
            return this;
        }

        public FeatureResultBuilder<ValueType> ruleId(@Nullable String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public FeatureResult<ValueType> build() {
            return new FeatureResult<ValueType>(this.value, this.source, this.experiment, this.experimentResult, this.ruleId);
        }

        public String toString() {
            return "FeatureResult.FeatureResultBuilder(value=" + this.value + ", source=" + (Object)((Object)this.source) + ", experiment=" + this.experiment + ", experimentResult=" + this.experimentResult + ", ruleId=" + this.ruleId + ")";
        }
    }
}

