/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.ConditionEvaluator;
import growthbook.sdk.java.Experiment;
import growthbook.sdk.java.ExperimentEvaluator;
import growthbook.sdk.java.ExperimentResult;
import growthbook.sdk.java.Feature;
import growthbook.sdk.java.FeatureResult;
import growthbook.sdk.java.FeatureResultSource;
import growthbook.sdk.java.FeatureRule;
import growthbook.sdk.java.GBContext;
import growthbook.sdk.java.GrowthBookJsonUtils;
import growthbook.sdk.java.GrowthBookUtils;
import growthbook.sdk.java.IFeatureEvaluator;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;

class FeatureEvaluator
implements IFeatureEvaluator {
    private final GrowthBookJsonUtils jsonUtils = GrowthBookJsonUtils.getInstance();
    private final ConditionEvaluator conditionEvaluator = new ConditionEvaluator();
    private final ExperimentEvaluator experimentEvaluator = new ExperimentEvaluator();

    FeatureEvaluator() {
    }

    @Override
    public <ValueType> FeatureResult<ValueType> evaluateFeature(String key, GBContext context, Class<ValueType> valueTypeClass) throws ClassCastException {
        FeatureResult emptyFeature = FeatureResult.builder().value(null).source(FeatureResultSource.UNKNOWN_FEATURE).build();
        try {
            JsonObject attributes;
            ValueType forcedValue;
            if (context.getAllowUrlOverride().booleanValue() && (forcedValue = this.evaluateForcedFeatureValueFromUrl(key, context.getUrl(), valueTypeClass)) != null) {
                return FeatureResult.builder().value(forcedValue).source(FeatureResultSource.URL_OVERRIDE).build();
            }
            JsonObject featuresJson = context.getFeatures();
            if (featuresJson == null || !featuresJson.has(key)) {
                return emptyFeature;
            }
            JsonElement featureJson = featuresJson.get(key);
            FeatureResult defaultValueFeature = FeatureResult.builder().value(null).source(FeatureResultSource.DEFAULT_VALUE).build();
            if (featureJson == null) {
                System.out.println("featureJson is null");
                return defaultValueFeature;
            }
            Feature feature = (Feature)this.jsonUtils.gson.fromJson(featureJson, Feature.class);
            if (feature == null) {
                return defaultValueFeature;
            }
            if (feature.getRules() == null || feature.getRules().isEmpty()) {
                Object value = GrowthBookJsonUtils.unwrap(feature.getDefaultValue());
                return FeatureResult.builder().source(FeatureResultSource.DEFAULT_VALUE).value(value).build();
            }
            String attributesJson = context.getAttributesJson();
            if (attributesJson == null) {
                attributesJson = "{}";
            }
            if ((attributes = context.getAttributes()) == null) {
                attributes = new JsonObject();
            }
            for (FeatureRule rule : feature.getRules()) {
                Experiment experiment;
                ExperimentResult result;
                if (rule.getCondition() != null && !this.conditionEvaluator.evaluateCondition(attributesJson, rule.getCondition().toString()).booleanValue()) continue;
                if (rule.getForce() != null) {
                    if (rule.getCoverage() != null) {
                        String attrValue;
                        Float hashFnv;
                        JsonElement attrValueElement;
                        String ruleKey = rule.getHashAttribute();
                        if (ruleKey == null) {
                            ruleKey = "id";
                        }
                        if ((attrValueElement = attributes.get(ruleKey)) == null || attrValueElement.isJsonNull()) continue;
                        boolean isEmpty = false;
                        if (attrValueElement.isJsonObject()) {
                            isEmpty = attrValueElement.getAsJsonObject().entrySet().size() == 0;
                        } else if (attrValueElement.isJsonArray()) {
                            isEmpty = attrValueElement.getAsJsonArray().size() == 0;
                        } else if (attrValueElement.isJsonPrimitive() && attrValueElement.getAsJsonPrimitive().isString()) {
                            isEmpty = attrValueElement.getAsString().isEmpty();
                        }
                        if (isEmpty || (hashFnv = GrowthBookUtils.hash((attrValue = attrValueElement.getAsString()) + key)).floatValue() > rule.getCoverage().floatValue()) continue;
                    }
                    Object value = GrowthBookJsonUtils.unwrap(rule.getForce());
                    return FeatureResult.builder().value(value).source(FeatureResultSource.FORCE).build();
                }
                String experimentKey = rule.getKey();
                if (experimentKey == null) {
                    experimentKey = key;
                }
                if (!(result = this.experimentEvaluator.evaluateExperiment(experiment = Experiment.builder().key(experimentKey).coverage(rule.getCoverage()).weights(rule.getWeights()).hashAttribute(rule.getHashAttribute()).namespace(rule.getNamespace()).variations(rule.getVariations()).build(), context, key)).getInExperiment().booleanValue()) continue;
                Object value = GrowthBookJsonUtils.unwrap(result.getValue());
                return FeatureResult.builder().value(value).source(FeatureResultSource.EXPERIMENT).experiment(experiment).experimentResult(result).build();
            }
            Object value = GrowthBookJsonUtils.unwrap(feature.getDefaultValue());
            return FeatureResult.builder().source(FeatureResultSource.DEFAULT_VALUE).value(value).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return emptyFeature;
        }
    }

    @Nullable
    private <ValueType> ValueType evaluateForcedFeatureValueFromUrl(String key, @Nullable String urlString, Class<ValueType> valueTypeClass) {
        if (urlString == null) {
            return null;
        }
        try {
            URL url = new URL(urlString);
            if (valueTypeClass.equals(Boolean.class)) {
                return (ValueType)GrowthBookUtils.getForcedBooleanValueFromUrl(key, url);
            }
            if (valueTypeClass.equals(String.class)) {
                return (ValueType)GrowthBookUtils.getForcedStringValueFromUrl(key, url);
            }
            if (valueTypeClass.equals(Integer.class)) {
                return (ValueType)GrowthBookUtils.getForcedIntegerValueFromUrl(key, url);
            }
            if (valueTypeClass.equals(Float.class)) {
                return (ValueType)GrowthBookUtils.getForcedFloatValueFromUrl(key, url);
            }
            if (valueTypeClass.equals(Double.class)) {
                return (ValueType)GrowthBookUtils.getForcedDoubleValueFromUrl(key, url);
            }
            return GrowthBookUtils.getForcedSerializableValueFromUrl(key, url, valueTypeClass, this.jsonUtils.gson);
        }
        catch (ClassCastException | MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

