/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import growthbook.sdk.java.GrowthBookJsonUtils;
import java.lang.reflect.Type;
import javax.annotation.Nullable;

public class ExperimentResult<ValueType> {
    @Nullable
    ValueType value;
    @Nullable
    Integer variationId;
    Boolean inExperiment;
    @Nullable
    String hashAttribute;
    @Nullable
    String hashValue;
    @Nullable
    String featureId;
    Boolean hashUsed;

    public String toJson() {
        return ExperimentResult.getJson(this).toString();
    }

    static <ValueType> JsonElement getJson(ExperimentResult<ValueType> object) {
        JsonObject json = new JsonObject();
        json.addProperty("featureId", object.getFeatureId());
        JsonElement valueElement = GrowthBookJsonUtils.getJsonElementForObject(object.getValue());
        json.add("value", valueElement);
        json.addProperty("variationId", (Number)object.getVariationId());
        json.addProperty("inExperiment", object.getInExperiment());
        json.addProperty("hashUsed", object.getHashUsed());
        json.addProperty("hashAttribute", object.getHashAttribute());
        json.addProperty("hashValue", object.getHashValue());
        return json;
    }

    public static <ValueType> JsonSerializer<ExperimentResult<ValueType>> getSerializer() {
        return new JsonSerializer<ExperimentResult<ValueType>>(){

            public JsonElement serialize(ExperimentResult<ValueType> src, Type typeOfSrc, JsonSerializationContext context) {
                return ExperimentResult.getJson(src);
            }
        };
    }

    private static <ValueType> Boolean $default$inExperiment() {
        return false;
    }

    private static <ValueType> String $default$hashAttribute() {
        return "id";
    }

    private static <ValueType> Boolean $default$hashUsed() {
        return false;
    }

    public static <ValueType> ExperimentResultBuilder<ValueType> builder() {
        return new ExperimentResultBuilder();
    }

    @Nullable
    public ValueType getValue() {
        return this.value;
    }

    @Nullable
    public Integer getVariationId() {
        return this.variationId;
    }

    public Boolean getInExperiment() {
        return this.inExperiment;
    }

    @Nullable
    public String getHashAttribute() {
        return this.hashAttribute;
    }

    @Nullable
    public String getHashValue() {
        return this.hashValue;
    }

    @Nullable
    public String getFeatureId() {
        return this.featureId;
    }

    public Boolean getHashUsed() {
        return this.hashUsed;
    }

    public void setValue(@Nullable ValueType value) {
        this.value = value;
    }

    public void setVariationId(@Nullable Integer variationId) {
        this.variationId = variationId;
    }

    public void setInExperiment(Boolean inExperiment) {
        this.inExperiment = inExperiment;
    }

    public void setHashAttribute(@Nullable String hashAttribute) {
        this.hashAttribute = hashAttribute;
    }

    public void setHashValue(@Nullable String hashValue) {
        this.hashValue = hashValue;
    }

    public void setFeatureId(@Nullable String featureId) {
        this.featureId = featureId;
    }

    public void setHashUsed(Boolean hashUsed) {
        this.hashUsed = hashUsed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExperimentResult)) {
            return false;
        }
        ExperimentResult other = (ExperimentResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$variationId = this.getVariationId();
        Integer other$variationId = other.getVariationId();
        if (this$variationId == null ? other$variationId != null : !((Object)this$variationId).equals(other$variationId)) {
            return false;
        }
        Boolean this$inExperiment = this.getInExperiment();
        Boolean other$inExperiment = other.getInExperiment();
        if (this$inExperiment == null ? other$inExperiment != null : !((Object)this$inExperiment).equals(other$inExperiment)) {
            return false;
        }
        Boolean this$hashUsed = this.getHashUsed();
        Boolean other$hashUsed = other.getHashUsed();
        if (this$hashUsed == null ? other$hashUsed != null : !((Object)this$hashUsed).equals(other$hashUsed)) {
            return false;
        }
        ValueType this$value = this.getValue();
        ValueType other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$hashAttribute = this.getHashAttribute();
        String other$hashAttribute = other.getHashAttribute();
        if (this$hashAttribute == null ? other$hashAttribute != null : !this$hashAttribute.equals(other$hashAttribute)) {
            return false;
        }
        String this$hashValue = this.getHashValue();
        String other$hashValue = other.getHashValue();
        if (this$hashValue == null ? other$hashValue != null : !this$hashValue.equals(other$hashValue)) {
            return false;
        }
        String this$featureId = this.getFeatureId();
        String other$featureId = other.getFeatureId();
        return !(this$featureId == null ? other$featureId != null : !this$featureId.equals(other$featureId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExperimentResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $variationId = this.getVariationId();
        result = result * 59 + ($variationId == null ? 43 : ((Object)$variationId).hashCode());
        Boolean $inExperiment = this.getInExperiment();
        result = result * 59 + ($inExperiment == null ? 43 : ((Object)$inExperiment).hashCode());
        Boolean $hashUsed = this.getHashUsed();
        result = result * 59 + ($hashUsed == null ? 43 : ((Object)$hashUsed).hashCode());
        ValueType $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $hashAttribute = this.getHashAttribute();
        result = result * 59 + ($hashAttribute == null ? 43 : $hashAttribute.hashCode());
        String $hashValue = this.getHashValue();
        result = result * 59 + ($hashValue == null ? 43 : $hashValue.hashCode());
        String $featureId = this.getFeatureId();
        result = result * 59 + ($featureId == null ? 43 : $featureId.hashCode());
        return result;
    }

    public String toString() {
        return "ExperimentResult(value=" + this.getValue() + ", variationId=" + this.getVariationId() + ", inExperiment=" + this.getInExperiment() + ", hashAttribute=" + this.getHashAttribute() + ", hashValue=" + this.getHashValue() + ", featureId=" + this.getFeatureId() + ", hashUsed=" + this.getHashUsed() + ")";
    }

    public ExperimentResult(@Nullable ValueType value, @Nullable Integer variationId, Boolean inExperiment, @Nullable String hashAttribute, @Nullable String hashValue, @Nullable String featureId, Boolean hashUsed) {
        this.value = value;
        this.variationId = variationId;
        this.inExperiment = inExperiment;
        this.hashAttribute = hashAttribute;
        this.hashValue = hashValue;
        this.featureId = featureId;
        this.hashUsed = hashUsed;
    }

    public static class ExperimentResultBuilder<ValueType> {
        private ValueType value;
        private Integer variationId;
        private boolean inExperiment$set;
        private Boolean inExperiment$value;
        private boolean hashAttribute$set;
        private String hashAttribute$value;
        private String hashValue;
        private String featureId;
        private boolean hashUsed$set;
        private Boolean hashUsed$value;

        ExperimentResultBuilder() {
        }

        public ExperimentResultBuilder<ValueType> value(@Nullable ValueType value) {
            this.value = value;
            return this;
        }

        public ExperimentResultBuilder<ValueType> variationId(@Nullable Integer variationId) {
            this.variationId = variationId;
            return this;
        }

        public ExperimentResultBuilder<ValueType> inExperiment(Boolean inExperiment) {
            this.inExperiment$value = inExperiment;
            this.inExperiment$set = true;
            return this;
        }

        public ExperimentResultBuilder<ValueType> hashAttribute(@Nullable String hashAttribute) {
            this.hashAttribute$value = hashAttribute;
            this.hashAttribute$set = true;
            return this;
        }

        public ExperimentResultBuilder<ValueType> hashValue(@Nullable String hashValue) {
            this.hashValue = hashValue;
            return this;
        }

        public ExperimentResultBuilder<ValueType> featureId(@Nullable String featureId) {
            this.featureId = featureId;
            return this;
        }

        public ExperimentResultBuilder<ValueType> hashUsed(Boolean hashUsed) {
            this.hashUsed$value = hashUsed;
            this.hashUsed$set = true;
            return this;
        }

        public ExperimentResult<ValueType> build() {
            Boolean inExperiment$value = this.inExperiment$value;
            if (!this.inExperiment$set) {
                inExperiment$value = ExperimentResult.$default$inExperiment();
            }
            String hashAttribute$value = this.hashAttribute$value;
            if (!this.hashAttribute$set) {
                hashAttribute$value = ExperimentResult.$default$hashAttribute();
            }
            Boolean hashUsed$value = this.hashUsed$value;
            if (!this.hashUsed$set) {
                hashUsed$value = ExperimentResult.$default$hashUsed();
            }
            return new ExperimentResult<ValueType>(this.value, this.variationId, inExperiment$value, hashAttribute$value, this.hashValue, this.featureId, hashUsed$value);
        }

        public String toString() {
            return "ExperimentResult.ExperimentResultBuilder(value=" + this.value + ", variationId=" + this.variationId + ", inExperiment$value=" + this.inExperiment$value + ", hashAttribute$value=" + this.hashAttribute$value + ", hashValue=" + this.hashValue + ", featureId=" + this.featureId + ", hashUsed$value=" + this.hashUsed$value + ")";
        }
    }
}

