/*
 * Decompiled with CFR 0.152.
 */
package growthbook.sdk.java.internal.services;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import growthbook.sdk.java.internal.services.ConditionEvaluator;
import growthbook.sdk.java.internal.services.GrowthBookJsonUtils;
import growthbook.sdk.java.internal.services.GrowthBookUtils;
import growthbook.sdk.java.internal.services.IExperimentEvaluator;
import growthbook.sdk.java.models.BucketRange;
import growthbook.sdk.java.models.Experiment;
import growthbook.sdk.java.models.ExperimentResult;
import growthbook.sdk.java.models.GBContext;
import growthbook.sdk.java.models.Namespace;
import growthbook.sdk.java.models.TrackingCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class ExperimentEvaluator
implements IExperimentEvaluator {
    private final ConditionEvaluator conditionEvaluator = new ConditionEvaluator();

    @Override
    public <ValueType> ExperimentResult<ValueType> evaluateExperiment(Experiment<ValueType> experiment, GBContext context, @Nullable String featureId) {
        Float coverage;
        String attributesJson;
        Boolean shouldEvaluate;
        Boolean isInNamespace;
        JsonElement attributeValueElement;
        String hashAttribute;
        Integer forcedVariation;
        ArrayList<Object> experimentVariations = experiment.getVariations();
        if (experimentVariations == null) {
            experimentVariations = new ArrayList();
        }
        if (context.getEnabled() != null && !context.getEnabled().booleanValue() || experimentVariations.size() < 2) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId);
        }
        Integer override = GrowthBookUtils.getQueryStringOverride(experiment.getKey(), context.getUrl(), (Integer)experimentVariations.size());
        if (override != null) {
            return this.getExperimentResult(experiment, context, override, true, false, featureId);
        }
        Map<String, Integer> forcedVariations = context.getForcedVariationsMap();
        if (forcedVariations == null) {
            forcedVariations = new HashMap<String, Integer>();
        }
        if ((forcedVariation = forcedVariations.get(experiment.getKey())) != null) {
            return this.getExperimentResult(experiment, context, forcedVariation, true, false, featureId);
        }
        if (experiment.getIsActive() != null && !experiment.getIsActive().booleanValue()) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId);
        }
        JsonObject attributes = context.getAttributes();
        if (attributes == null) {
            attributes = new JsonObject();
        }
        if ((hashAttribute = experiment.getHashAttribute()) == null || hashAttribute.equals("")) {
            hashAttribute = "id";
        }
        if ((attributeValueElement = attributes.get(hashAttribute)) == null || attributeValueElement.isJsonNull() || attributeValueElement.isJsonPrimitive() && attributeValueElement.getAsJsonPrimitive().isString() && Objects.equals(attributeValueElement.getAsString(), "")) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId);
        }
        String attributeValue = attributeValueElement.getAsString();
        Namespace namespace = experiment.getNamespace();
        if (namespace != null && !(isInNamespace = GrowthBookUtils.inNameSpace(attributeValue, namespace)).booleanValue()) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId);
        }
        String jsonStringCondition = experiment.getConditionJson();
        if (jsonStringCondition != null && !(shouldEvaluate = this.conditionEvaluator.evaluateCondition(attributesJson = GrowthBookJsonUtils.getInstance().gson.toJson((JsonElement)attributes), jsonStringCondition)).booleanValue()) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId);
        }
        ArrayList<Float> weights = experiment.getWeights();
        if (weights == null) {
            weights = GrowthBookUtils.getEqualWeights(experiment.getVariations().size());
        }
        if ((coverage = experiment.getCoverage()) == null) {
            coverage = Float.valueOf(1.0f);
        }
        ArrayList<BucketRange> bucketRanges = GrowthBookUtils.getBucketRanges(experiment.getVariations().size(), coverage, weights);
        Float hash = GrowthBookUtils.hash(attributeValue + experiment.getKey());
        Integer assignedVariation = GrowthBookUtils.chooseVariation(hash, bucketRanges);
        if (assignedVariation == -1) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId);
        }
        Integer force = experiment.getForce();
        if (force != null) {
            return this.getExperimentResult(experiment, context, force, true, false, featureId);
        }
        if (context.getIsQaMode() != null && context.getIsQaMode().booleanValue()) {
            return this.getExperimentResult(experiment, context, 0, false, false, featureId);
        }
        ExperimentResult<ValueType> result = this.getExperimentResult(experiment, context, assignedVariation, true, true, featureId);
        TrackingCallback trackingCallback = context.getTrackingCallback();
        if (trackingCallback != null) {
            trackingCallback.onTrack(experiment, result);
        }
        return result;
    }

    private <ValueType> ExperimentResult<ValueType> getExperimentResult(Experiment<ValueType> experiment, GBContext context, Integer variationIndex, Boolean inExperiment, Boolean hashUsed, String featureId) {
        String hashAttribute;
        Integer targetVariationIndex = variationIndex;
        ArrayList<Object> experimentVariations = experiment.getVariations();
        if (experimentVariations == null) {
            experimentVariations = new ArrayList();
        }
        if (variationIndex < 0 || variationIndex >= experimentVariations.size()) {
            variationIndex = 0;
            inExperiment = false;
        }
        Object targetValue = null;
        if (targetVariationIndex < 0 || targetVariationIndex >= experimentVariations.size()) {
            targetVariationIndex = 0;
        }
        if (!experimentVariations.isEmpty()) {
            targetValue = experiment.getVariations().get(targetVariationIndex);
        }
        if ((hashAttribute = experiment.getHashAttribute()) == null) {
            hashAttribute = "id";
        }
        String hashValue = "";
        JsonObject attributes = context.getAttributes();
        if (attributes == null) {
            attributes = new JsonObject();
        } else {
            JsonElement hashAttributeElement = attributes.get(hashAttribute);
            if (hashAttributeElement != null && !hashAttributeElement.isJsonNull()) {
                hashValue = hashAttributeElement.getAsString();
            }
        }
        return ExperimentResult.builder().inExperiment(inExperiment).variationId(variationIndex).featureId(featureId).hashValue(hashValue).hashUsed(hashUsed).hashAttribute(hashAttribute).value(targetValue).build();
    }
}

