/*
 * Decompiled with CFR 0.152.
 */
package asteroid.utils;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.StringGroovyMethods;

public final class ClassNodeUtils {
    public void addProperty(ClassNode classNode, PropertyNode propertyNode) {
        classNode.addProperty(propertyNode);
    }

    public void addPropertyIfNotPresent(ClassNode classNode, PropertyNode propertyNode) {
        if (!classNode.hasProperty(propertyNode.getName())) {
            classNode.addProperty(propertyNode);
        }
    }

    public void addMethod(ClassNode classNode, MethodNode methodNode) {
        classNode.addMethod(methodNode);
    }

    public void addMethodIfNotPresent(ClassNode classNode, MethodNode methodNode) {
        if (!classNode.hasMethod(methodNode.getName(), methodNode.getParameters())) {
            classNode.addMethod(methodNode);
        }
    }

    public void addInterfaces(ClassNode classNode, Class ... interfaces) {
        for (Class clazz : interfaces) {
            ClassNode nextInterface = ClassHelper.make((Class)clazz, (boolean)false);
            classNode.addInterface(nextInterface);
        }
    }

    public void addInterfaces(ClassNode classNode, ClassNode ... interfaces) {
        for (ClassNode nextInterface : interfaces) {
            classNode.addInterface(nextInterface);
        }
    }

    public List<FieldNode> getInstancePropertyFields(ClassNode classNode) {
        return GeneralUtils.getInstancePropertyFields((ClassNode)classNode);
    }

    public AnnotationNode getAnnotationFrom(ClassNode classNode, ClassNode annotationType) {
        return (AnnotationNode)DefaultGroovyMethods.find((Collection)classNode.getAnnotations(annotationType));
    }

    public AnnotationNode getAnnotationFrom(ClassNode classNode, String simpleName) {
        return (AnnotationNode)DefaultGroovyMethods.find((Collection)classNode.getAnnotations(), this.bySimpleName(simpleName));
    }

    public void removeAnnotation(AnnotatedNode annotated, AnnotationNode annotation) {
        annotated.getAnnotations().remove(annotation);
    }

    private Closure<Boolean> bySimpleName(final String annotationName) {
        return new Closure(null){

            public boolean doCall(AnnotationNode node) {
                return node.getClassNode().getNameWithoutPackage().equals(annotationName);
            }
        };
    }

    public Boolean hasFieldOfType(ClassNode node, final String qualifiedName) {
        List nodeFields = node.getFields();
        Closure<Boolean> predicate = new Closure<Boolean>(null){

            public Boolean doCall(FieldNode fieldNode) {
                return ClassNodeUtils.this.isOrExtends(fieldNode.getType(), qualifiedName);
            }
        };
        return DefaultGroovyMethods.any((Iterable)nodeFields, (Closure)predicate);
    }

    public Boolean isOrImplements(Class child, Class parent) {
        return this.isOrImplements(ClassHelper.make((Class)child, (boolean)false), parent);
    }

    public Boolean isOrImplements(ClassNode child, Class parent) {
        return GeneralUtils.isOrImplements((ClassNode)child, (ClassNode)ClassHelper.make((Class)parent, (boolean)false));
    }

    public Boolean isOrImplements(ClassNode child, String parent) {
        return GeneralUtils.isOrImplements((ClassNode)child, (ClassNode)ClassHelper.make((String)parent));
    }

    public Boolean isOrExtends(ClassNode child, Class parent) {
        ClassNode extendedType = ClassHelper.make((Class)parent, (boolean)false);
        return this.isOrExtends(child, extendedType);
    }

    public Boolean isOrExtends(ClassNode child, ClassNode parent) {
        return child.equals((Object)parent) || child.isDerivedFrom(parent);
    }

    public Boolean isOrExtends(ClassNode child, String parent) {
        return child.equals((Object)parent) || child.isDerivedFrom(ClassHelper.make((String)parent));
    }

    public Boolean isOrExtendsUnsafe(ClassNode child, ClassNode parent) {
        return child.equals((Object)parent) || child.isDerivedFrom(parent) || child.getSuperClass().getNameWithoutPackage().equals(parent.getNameWithoutPackage());
    }

    public MethodNode findMethodByName(ClassNode classNode, String methodName) {
        return (MethodNode)DefaultGroovyMethods.first(this.findAllMethodByName(classNode, methodName));
    }

    public List<MethodNode> findAllMethodByName(ClassNode classNode, String methodName) {
        return classNode.getMethods(methodName);
    }

    public void addImport(ClassNode classNode, Class clazz) {
        classNode.getModule().addImport(clazz.getSimpleName(), ClassHelper.make((Class)clazz, (boolean)false));
    }

    public void addImport(ClassNode classNode, String clazz) {
        classNode.getModule().addImport(this.getClassNameFromString(clazz), ClassHelper.make((String)clazz));
    }

    private String getClassNameFromString(String clazz) {
        if (clazz == null || clazz.isEmpty()) {
            return clazz;
        }
        int clazzPackage = clazz.lastIndexOf(46);
        CharSequence name = StringGroovyMethods.take((CharSequence)clazz, (int)clazzPackage);
        return name.toString();
    }

    public void addImport(ClassNode classNode, Class clazz, String alias) {
        classNode.getModule().addImport(alias, ClassHelper.make((Class)clazz, (boolean)false));
    }

    public void addImport(ClassNode classNode, String clazz, String alias) {
        classNode.getModule().addImport(alias, ClassHelper.make((String)clazz));
    }
}

