/*
 * Decompiled with CFR 0.152.
 */
package asteroid.utils;

import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;

public final class AnnotationNodeUtils {
    public static final String ANNOTATION_VALUE = "value";

    public String getStringValue(AnnotationNode annotationNode) {
        Expression expr = annotationNode.getMember(ANNOTATION_VALUE);
        if (expr != null) {
            return expr.getText();
        }
        return null;
    }

    public <T> T get(AnnotationNode annotationNode, Class<T> clazz) {
        Object value = this.resolveValueFrom(annotationNode.getMember(ANNOTATION_VALUE));
        return clazz.cast(value);
    }

    public <T> T get(AnnotationNode annotationNode, String name, Class<T> clazz) {
        Object value = this.resolveValueFrom(annotationNode.getMember(name));
        return clazz.cast(value);
    }

    private Object resolveValueFrom(Expression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof ClassExpression) {
            return ((ClassExpression)ClassExpression.class.cast(expression)).getText();
        }
        if (expression instanceof ConstantExpression) {
            return ((ConstantExpression)ConstantExpression.class.cast(expression)).getValue();
        }
        if (expression instanceof PropertyExpression) {
            return ((PropertyExpression)PropertyExpression.class.cast(expression)).getPropertyAsString();
        }
        return expression.toString();
    }
}

