/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.player.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import net.pubnative.player.R;

public class CountDownView
extends FrameLayout {
    private ProgressBar progressBarView;
    private TextView progressTextView;

    public CountDownView(Context context) {
        super(context);
        this.init(context);
    }

    public CountDownView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public CountDownView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context ctx) {
        View rootView = CountDownView.inflate((Context)ctx, (int)R.layout.pubnative_player_count_down, (ViewGroup)this);
        this.progressBarView = (ProgressBar)rootView.findViewById(R.id.view_progress_bar);
        this.progressTextView = (TextView)rootView.findViewById(R.id.view_progress_text);
        RotateAnimation makeVertical = new RotateAnimation(0.0f, -90.0f, 1, 0.5f, 1, 0.5f);
        makeVertical.setFillAfter(true);
        this.progressBarView.startAnimation((Animation)makeVertical);
    }

    public void setProgress(int currentMs, int totalMs) {
        this.progressBarView.setMax(totalMs);
        this.progressBarView.setSecondaryProgress(totalMs);
        this.progressBarView.setProgress(currentMs);
        int remainSec = (totalMs - currentMs) / 1000 + 1;
        this.progressTextView.setText((CharSequence)String.valueOf(remainSec));
    }
}

