/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.player;

import android.content.Context;
import android.os.AsyncTask;
import java.util.HashMap;
import net.pubnative.player.model.VASTModel;
import net.pubnative.player.processor.VASTProcessor;
import net.pubnative.player.util.CacheManager;
import net.pubnative.player.util.DefaultMediaPicker;
import net.pubnative.player.util.VASTLog;

public class VASTParser
extends AsyncTask<String, Object, VASTModel> {
    private static final String TAG = VASTParser.class.getName();
    public static final int ERROR_NONE = 0;
    public static final int ERROR_XML_OPEN_OR_READ = 1;
    public static final int ERROR_XML_PARSE = 2;
    public static final int ERROR_POST_VALIDATION = 3;
    public static final int ERROR_EXCEEDED_WRAPPER_LIMIT = 4;
    private static final HashMap<Integer, VASTModel> parsedVast = new HashMap();
    private Context context = null;
    private Listener listener = null;
    private int resultError = 0;

    public static Boolean hasParsed(String xml) {
        return parsedVast.containsKey(xml.hashCode());
    }

    public static VASTModel getParsedModel(String xml) {
        return parsedVast.get(xml.hashCode());
    }

    public VASTParser(Context context) {
        this.context = context;
    }

    public VASTParser setListener(Listener listener) {
        VASTLog.v(TAG, "setListener");
        this.listener = listener;
        return this;
    }

    protected VASTModel doInBackground(String ... params) {
        VASTLog.v(TAG, "doInBackground");
        VASTModel result = null;
        this.resultError = 0;
        String vastXML = null;
        if (params.length > 0) {
            vastXML = params[0];
        }
        if (vastXML != null) {
            VASTModel parsedResult;
            if (parsedVast.containsKey(vastXML.hashCode()) && (parsedResult = parsedVast.get(vastXML.hashCode())) != null) {
                return parsedResult;
            }
            DefaultMediaPicker mediaPicker = new DefaultMediaPicker(this.context);
            VASTProcessor processor = new VASTProcessor(mediaPicker);
            int error = processor.process(params[0]);
            if (error == 0) {
                result = processor.getModel();
                parsedVast.put(vastXML.hashCode(), result);
            }
        }
        return result;
    }

    protected void onPostExecute(final VASTModel result) {
        VASTLog.v(TAG, "onPostExecute");
        if (this.listener != null) {
            if (result == null) {
                this.listener.onVASTParserError(this.resultError);
            } else if (CacheManager.has(this.context, result.getPickedMediaFileURL())) {
                this.listener.onVASTParserFinished(result);
            } else {
                CacheManager.CacheProgressListener cacheListener = new CacheManager.CacheProgressListener(){

                    @Override
                    public void onCacheSuccess() {
                        VASTParser.this.listener.onVASTParserFinished(result);
                    }

                    @Override
                    public void onCacheFailed(Throwable t) {
                        VASTParser.this.listener.onVASTParserError(VASTParser.this.resultError);
                    }
                };
                CacheManager.put(this.context, result.getPickedMediaFileURL(), cacheListener);
            }
        }
    }

    public static interface Listener {
        public void onVASTParserError(int var1);

        public void onVASTParserFinished(VASTModel var1);
    }
}

