/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.ArrayList;
import java.util.HashMap;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.Path;
import org.graphstream.ui.graphicGraph.GraphPosLengthUtils;

public class AStar
implements Algorithm {
    protected Graph graph;
    protected String source;
    protected String target;
    protected Costs costs = new DefaultCosts();
    protected HashMap<Node, AStarNode> open = new HashMap();
    protected HashMap<Node, AStarNode> closed = new HashMap();
    protected Path result;
    protected boolean pathFound = false;

    public AStar() {
    }

    public AStar(Graph graph) {
        this.init(graph);
    }

    public AStar(Graph graph, String src, String trg) {
        this(graph);
        this.setSource(src);
        this.setTarget(trg);
    }

    @Parameter(value=true)
    public void setSource(String nodeName) {
        this.clearAll();
        this.source = nodeName;
    }

    @Parameter(value=true)
    public void setTarget(String nodeName) {
        this.clearAll();
        this.target = nodeName;
    }

    @Parameter
    public void setCosts(Costs costs) {
        this.costs = costs;
    }

    @Override
    public void init(Graph graph) {
        this.clearAll();
        this.graph = graph;
    }

    @Override
    public void compute() {
        if (this.source != null && this.target != null) {
            Node sourceNode = this.graph.getNode(this.source);
            Node targetNode = this.graph.getNode(this.target);
            if (sourceNode == null) {
                throw new RuntimeException("source node '" + this.source + "' does not exist in the graph");
            }
            if (targetNode == null) {
                throw new RuntimeException("target node '" + this.target + "' does not exist in the graph");
            }
            this.aStar(sourceNode, targetNode);
        }
    }

    @Result
    public Path getShortestPath() {
        return this.result;
    }

    public boolean noPathFound() {
        return !this.pathFound;
    }

    public Path buildPath(AStarNode target) {
        Path path = new Path();
        ArrayList<AStarNode> thePath = new ArrayList<AStarNode>();
        AStarNode node = target;
        while (node != null) {
            thePath.add(node);
            node = node.parent;
        }
        int n = thePath.size();
        if (n > 1) {
            AStarNode current = (AStarNode)thePath.get(n - 1);
            AStarNode follow = (AStarNode)thePath.get(n - 2);
            path.add(current.node, follow.edge);
            current = follow;
            for (int i = n - 3; i >= 0; --i) {
                follow = (AStarNode)thePath.get(i);
                path.add(follow.edge);
                current = follow;
            }
        }
        return path;
    }

    public void compute(String source, String target) {
        this.setSource(source);
        this.setTarget(target);
        this.compute();
    }

    protected void clearAll() {
        this.open.clear();
        this.closed.clear();
        this.result = null;
        this.pathFound = false;
    }

    protected void aStar(Node sourceNode, Node targetNode) {
        this.clearAll();
        this.open.put(sourceNode, new AStarNode(sourceNode, null, null, 0.0, this.costs.heuristic(sourceNode, targetNode)));
        this.pathFound = false;
        while (!this.open.isEmpty()) {
            AStarNode current = this.getNextBetterNode();
            assert (current != null);
            if (current.node == targetNode) {
                assert (current.edge != null);
                this.pathFound = true;
                this.result = this.buildPath(current);
                return;
            }
            this.open.remove(current.node);
            this.closed.put(current.node, current);
            current.node.leavingEdges().forEach(edge -> {
                AStarNode alreadyInClosed;
                Node next = edge.getOpposite(current.node);
                double h = this.costs.heuristic(next, targetNode);
                double g = current.g + this.costs.cost(current.node, (Edge)edge, next);
                double f = g + h;
                AStarNode alreadyInOpen = this.open.get(next);
                if (!(alreadyInOpen != null && alreadyInOpen.rank <= f || (alreadyInClosed = this.closed.get(next)) != null && alreadyInClosed.rank <= f)) {
                    this.closed.remove(next);
                    this.open.put(next, new AStarNode(next, (Edge)edge, current, g, h));
                }
            });
        }
    }

    protected AStarNode getNextBetterNode() {
        AStarNode theChosenOne = null;
        theChosenOne = this.open.values().stream().min((n, m) -> Double.compare(n.rank, m.rank)).get();
        return theChosenOne;
    }

    protected class AStarNode {
        public Node node;
        public AStarNode parent;
        public Edge edge;
        public double g;
        public double h;
        public double rank;

        public AStarNode(Node node, Edge edge, AStarNode parent, double g, double h) {
            this.node = node;
            this.edge = edge;
            this.parent = parent;
            this.g = g;
            this.h = h;
            this.rank = g + h;
        }
    }

    public static class DistanceCosts
    implements Costs {
        @Override
        public double heuristic(Node node, Node target) {
            double[] xy1 = GraphPosLengthUtils.nodePosition((Node)node);
            double[] xy2 = GraphPosLengthUtils.nodePosition((Node)target);
            double x = xy2[0] - xy1[0];
            double y = xy2[1] - xy1[1];
            double z = xy1.length > 2 && xy2.length > 2 ? xy2[2] - xy1[2] : 0.0;
            return Math.sqrt(x * x + y * y + z * z);
        }

        @Override
        public double cost(Node parent, Edge edge, Node next) {
            return GraphPosLengthUtils.edgeLength((Edge)edge);
        }
    }

    public static class DefaultCosts
    implements Costs {
        protected String weightAttribute = "weight";

        public DefaultCosts() {
        }

        public DefaultCosts(String weightAttributeName) {
            this.weightAttribute = weightAttributeName;
        }

        @Override
        public double heuristic(Node node, Node target) {
            return 0.0;
        }

        @Override
        public double cost(Node parent, Edge edge, Node next) {
            if (edge != null && edge.hasNumber(this.weightAttribute)) {
                return edge.getNumber(this.weightAttribute);
            }
            return 1.0;
        }
    }

    public static interface Costs {
        public double heuristic(Node var1, Node var2);

        public double cost(Node var1, Edge var2, Node var3);
    }
}

