/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.senddb;

import android.app.AlertDialog;
import android.content.Context;
import android.widget.ListAdapter;
import com.viettel.senddb.GetSendDBFileMethodCallback;
import com.viettel.senddb.R;
import com.viettel.senddb.SendDBCache;
import com.viettel.senddb.SendDBFile;
import com.viettel.senddb.SendDBFileMethod;
import com.viettel.senddb.SendDBFileMethodAdapter;
import com.viettel.senddb.SendDBFileMethodSelectorCallback;
import java.util.ArrayList;
import java.util.List;

public class SendDBFileMethodSelector {
    private final Context context;
    List<SendDBFileMethod> methodList = null;

    public SendDBFileMethodSelector(Context context) {
        this.context = context;
    }

    private String getString(int resId) {
        if (this.context != null) {
            return this.context.getString(resId);
        }
        return null;
    }

    public SendDBFileMethodSelector setAvailableMethods(SendDBFileMethod[] sendDBMethods) {
        if (sendDBMethods != null) {
            this.methodList = new ArrayList<SendDBFileMethod>();
            block8: for (SendDBFileMethod method : sendDBMethods) {
                switch (method.code) {
                    case "gmail": {
                        method.text = this.getString(R.string.SEND_DB_BY_GMAIL);
                        method.iconId = R.drawable.ic_gmail;
                        this.methodList.add(method);
                        continue block8;
                    }
                    case "firebase": {
                        method.text = this.getString(R.string.SEND_DB_BY_FIREBASE);
                        method.iconId = R.drawable.ic_storage;
                        this.methodList.add(method);
                    }
                }
            }
        }
        return this;
    }

    public AlertDialog show(SendDBFileMethodSelectorCallback selectorCallback, GetSendDBFileMethodCallback getSendDBFileMethodCallback, boolean cancelable) {
        if (this.methodList == null || this.methodList.isEmpty()) {
            if (selectorCallback != null) {
                String notify = null;
                if (this.context != null) {
                    notify = this.context.getString(R.string.NOT_HAVE_ANY_SEND_DB_METHOD);
                }
                selectorCallback.onError(notify, new Exception("Not have any method, please check AP_PARAM table with AP_PARAM_CODE = 'SEND_DB_METHOD' or something else, available methods: firebase, gmail"));
            }
            return null;
        }
        if (this.methodList.size() == 1) {
            if (selectorCallback != null && getSendDBFileMethodCallback != null) {
                selectorCallback.onChoose(this.decideSendDBMethod(this.methodList.get((int)0).code, getSendDBFileMethodCallback));
            }
            return null;
        }
        AlertDialog.Builder alertDialog = new AlertDialog.Builder(this.context);
        SendDBFileMethodAdapter adapter = new SendDBFileMethodAdapter(this.context, this.methodList);
        alertDialog.setTitle((CharSequence)this.getString(R.string.CHOOSE_SEND_DB_METHOD));
        alertDialog.setCancelable(cancelable);
        alertDialog.setSingleChoiceItems((ListAdapter)adapter, 0, (dialog, which) -> {
            if (selectorCallback != null) {
                boolean isOutOfSubmissions;
                SendDBFileMethod chosen = this.methodList.get(which);
                int numberOfTimesSendDB = SendDBCache.getNumberOfTimesSendDB(this.context, chosen.code);
                boolean bl = isOutOfSubmissions = numberOfTimesSendDB > chosen.maxNumberOfTime;
                if (isOutOfSubmissions) {
                    String notify = null;
                    if (this.context != null) {
                        notify = this.context.getString(R.string.BLOCK_SEND_DB);
                    }
                    selectorCallback.onError(notify, new Exception("SEND DB " + chosen.code + ": Out of submissions. Max: " + chosen.maxNumberOfTime + ", submitted: " + numberOfTimesSendDB));
                } else if (getSendDBFileMethodCallback != null) {
                    selectorCallback.onChoose(this.decideSendDBMethod(chosen.code, getSendDBFileMethodCallback));
                }
            }
            dialog.dismiss();
        });
        return alertDialog.show();
    }

    SendDBFile decideSendDBMethod(String methodCode, GetSendDBFileMethodCallback callback) {
        if (callback != null) {
            if ("firebase".equals(methodCode)) {
                return callback.onGetSendDBFileByFirebase();
            }
            return callback.onGetSendDBFileByGmail();
        }
        return null;
    }
}

