/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.senddb;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import com.viettel.senddb.DBMetadata;
import com.viettel.senddb.R;
import com.viettel.senddb.SendDBFile;
import com.viettel.senddb.SendDBFileCallback;
import java.util.List;

public class SendDBFileByGmail
implements SendDBFile {
    private final String subject;
    private final String content;
    private final String[] recipients;

    public SendDBFileByGmail(@NonNull String subject, @NonNull String content, @NonNull String[] recipients) {
        this.subject = subject;
        this.content = content;
        this.recipients = recipients;
    }

    @Override
    public void send(Context context, Uri fileUri, DBMetadata dbMetadata, SendDBFileCallback callback) {
        block5: {
            Intent emailIntent = new Intent("android.intent.action.SEND");
            emailIntent.putExtra("android.intent.extra.EMAIL", this.recipients);
            emailIntent.putExtra("android.intent.extra.SUBJECT", this.subject);
            emailIntent.putExtra("android.intent.extra.TEXT", this.content);
            emailIntent.setType("text/plain");
            emailIntent.putExtra("android.intent.extra.STREAM", (Parcelable)fileUri);
            emailIntent.addFlags(1);
            emailIntent.addFlags(2);
            emailIntent.addFlags(0x10000000);
            PackageManager pm = context.getPackageManager();
            List matches = pm.queryIntentActivities(emailIntent, 0);
            ResolveInfo best = null;
            for (ResolveInfo info : matches) {
                if (!info.activityInfo.packageName.endsWith(".gm") && !info.activityInfo.name.toLowerCase().contains("gmail")) continue;
                best = info;
            }
            if (best != null) {
                emailIntent.setClassName(best.activityInfo.packageName, best.activityInfo.name);
            }
            try {
                context.startActivity(emailIntent);
                if (callback != null) {
                    String notifyString = context.getString(R.string.PRE_SEND_DB_BY_GMAIL);
                    boolean NO_BLOCK_CAUSE_BY_OPEN_MAIL_ACTIVITY = false;
                    callback.onPreSend(notifyString, false);
                }
            }
            catch (Exception e) {
                Log.e((String)"Send db by gmail", (String)e.getMessage());
                if (callback == null) break block5;
                callback.onSendFailed(null, e);
            }
        }
    }

    @Override
    public void cancel() {
    }
}

