/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.statusbarcompat.compat;

import android.app.Activity;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.Window;
import per.goweii.statusbarcompat.compat.OsCompat;
import per.goweii.statusbarcompat.utils.DarkModeUtils;

public class OsCompatOppo
implements OsCompat {
    @Override
    public boolean isDarkIconMode(@NonNull Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return false;
        }
        return this.isDarkIconMode((Activity)activity);
    }

    @Override
    public boolean isDarkIconMode(@NonNull Activity activity) {
        Window window = activity.getWindow();
        if (window == null) {
            return false;
        }
        return this.isDarkIconMode(window);
    }

    @Override
    public boolean isDarkIconMode(@NonNull Window window) {
        return OppoStatusBarUtils.isDarkIconMode(window);
    }

    @Override
    public void setDarkIconMode(@NonNull Fragment fragment, boolean darkIconMode) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        this.setDarkIconMode((Activity)activity, darkIconMode);
    }

    @Override
    public void setDarkIconMode(@NonNull Activity activity, boolean darkIconMode) {
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        this.setDarkIconMode(window, darkIconMode);
    }

    @Override
    public void setDarkIconMode(@NonNull Window window, boolean darkIconMode) {
        OppoStatusBarUtils.setDarkIconMode(window, darkIconMode);
    }

    private static class OppoStatusBarUtils {
        private static final int SYSTEM_UI_FLAG_OP_STATUS_BAR_TINT = 16;

        private OppoStatusBarUtils() {
        }

        private static boolean isDarkIconMode(Window window) {
            if (Build.VERSION.SDK_INT >= 23) {
                return DarkModeUtils.isDarkIconMode(window);
            }
            if (Build.VERSION.SDK_INT >= 21) {
                int vis = window.getDecorView().getSystemUiVisibility();
                return 16 == (0x10 & vis);
            }
            return false;
        }

        private static void setDarkIconMode(Window window, boolean darkMode) {
            if (Build.VERSION.SDK_INT >= 23) {
                DarkModeUtils.setDarkIconMode(window, darkMode);
            } else if (Build.VERSION.SDK_INT >= 21) {
                int vis = window.getDecorView().getSystemUiVisibility();
                vis = darkMode ? (vis |= 0x10) : (vis &= 0xFFFFFFEF);
                window.getDecorView().setSystemUiVisibility(vis);
            }
        }
    }
}

