/*
 * Decompiled with CFR 0.152.
 */
package per.goweii.statusbarcompat.compat;

import android.app.Activity;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import per.goweii.statusbarcompat.compat.OsCompat;
import per.goweii.statusbarcompat.utils.DarkModeUtils;

public class OsCompatMiui
implements OsCompat {
    @Override
    public boolean isDarkIconMode(@NonNull Fragment fragment) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return false;
        }
        return this.isDarkIconMode((Activity)activity);
    }

    @Override
    public boolean isDarkIconMode(@NonNull Activity activity) {
        Window window = activity.getWindow();
        if (window == null) {
            return false;
        }
        return this.isDarkIconMode(window);
    }

    @Override
    public boolean isDarkIconMode(@NonNull Window window) {
        return MiuiStatusBarUtils.isDarkIconMode(window);
    }

    @Override
    public void setDarkIconMode(@NonNull Fragment fragment, boolean darkIconMode) {
        FragmentActivity activity = fragment.getActivity();
        if (activity == null) {
            return;
        }
        this.setDarkIconMode((Activity)activity, darkIconMode);
    }

    @Override
    public void setDarkIconMode(@NonNull Activity activity, boolean darkIconMode) {
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        this.setDarkIconMode(window, darkIconMode);
    }

    @Override
    public void setDarkIconMode(@NonNull Window window, boolean darkIconMode) {
        MiuiStatusBarUtils.setDarkIconMode(window, darkIconMode);
    }

    private static class MiuiStatusBarUtils {
        private MiuiStatusBarUtils() {
        }

        private static boolean isDarkIconMode(Window window) {
            if (Build.VERSION.SDK_INT >= 23) {
                return DarkModeUtils.isDarkIconMode(window);
            }
            return MiuiStatusBarUtils.isMiuiDarkIconMode(window);
        }

        private static boolean isMiuiDarkIconMode(Window window) {
            Class<?> clazz = window.getClass();
            try {
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                int darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("getExtraFlags", new Class[0]);
                int miuiFlags = (Integer)extraFlagField.invoke((Object)window, new Object[0]);
                return darkModeFlag == (darkModeFlag & miuiFlags);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        private static void setDarkIconMode(Window window, boolean darkIconMode) {
            if (Build.VERSION.SDK_INT >= 23) {
                DarkModeUtils.setDarkIconMode(window, darkIconMode);
            } else {
                MiuiStatusBarUtils.setMiuiDarkIconMode(window, darkIconMode);
            }
        }

        private static void setMiuiDarkIconMode(Window window, boolean darkIconMode) {
            Class<?> clazz = window.getClass();
            try {
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                int darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                extraFlagField.invoke((Object)window, darkIconMode ? darkModeFlag : 0, darkModeFlag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

