/*
 * Decompiled with CFR 0.152.
 */
package com.gm.repository.rxerrorhandler.handler;

import android.util.Log;
import io.reactivex.Flowable;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Function;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public class RetryWithDelayOfFlowable
implements Function<Flowable<Throwable>, Publisher<?>> {
    public final String TAG = this.getClass().getSimpleName();
    private final int maxRetries;
    private final int retryDelaySecond;
    private int retryCount;

    public RetryWithDelayOfFlowable(int maxRetries, int retryDelaySecond) {
        this.maxRetries = maxRetries;
        this.retryDelaySecond = retryDelaySecond;
    }

    public Publisher<?> apply(@NonNull Flowable<Throwable> throwableFlowable) throws Exception {
        return throwableFlowable.flatMap(new Function<Throwable, Publisher<?>>(){

            public Publisher<?> apply(@NonNull Throwable throwable) throws Exception {
                if (++RetryWithDelayOfFlowable.this.retryCount <= RetryWithDelayOfFlowable.this.maxRetries) {
                    Log.d((String)RetryWithDelayOfFlowable.this.TAG, (String)("Flowable get error, it will try after " + RetryWithDelayOfFlowable.this.retryDelaySecond + " second, retry count " + RetryWithDelayOfFlowable.this.retryCount));
                    return Flowable.timer((long)RetryWithDelayOfFlowable.this.retryDelaySecond, (TimeUnit)TimeUnit.SECONDS);
                }
                return Flowable.error((Throwable)throwable);
            }
        });
    }
}

