/*
 * Decompiled with CFR 0.152.
 */
package com.gm.repository.rxerrorhandler.core;

import android.content.Context;
import com.gm.repository.rxerrorhandler.handler.ErrorHandlerFactory;
import com.gm.repository.rxerrorhandler.handler.listener.ResponseErrorListener;

public class RxErrorHandler {
    public final String TAG = this.getClass().getSimpleName();
    private ErrorHandlerFactory mHandlerFactory;

    private RxErrorHandler(Builder builder) {
        this.mHandlerFactory = builder.errorHandlerFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ErrorHandlerFactory getHandlerFactory() {
        return this.mHandlerFactory;
    }

    public static final class Builder {
        private Context context;
        private ResponseErrorListener mResponseErrorListener;
        private ErrorHandlerFactory errorHandlerFactory;

        private Builder() {
        }

        public Builder with(Context context) {
            this.context = context;
            return this;
        }

        public Builder responseErrorListener(ResponseErrorListener responseErrorListener) {
            this.mResponseErrorListener = responseErrorListener;
            return this;
        }

        public RxErrorHandler build() {
            if (this.context == null) {
                throw new IllegalStateException("Context is required");
            }
            if (this.mResponseErrorListener == null) {
                throw new IllegalStateException("ResponseErrorListener is required");
            }
            this.errorHandlerFactory = new ErrorHandlerFactory(this.context, this.mResponseErrorListener);
            return new RxErrorHandler(this);
        }
    }
}

