/*
 * Decompiled with CFR 0.152.
 */
package com.gm.repository.http;

import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CharacterHandler {
    public static final InputFilter emojiFilter = new InputFilter(){
        Pattern emoji = Pattern.compile("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]", 66);

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            Matcher emojiMatcher = this.emoji.matcher(source);
            if (emojiMatcher.find()) {
                return "";
            }
            return null;
        }
    };

    private CharacterHandler() {
        throw new IllegalStateException("you can't instantiate me!");
    }

    public static String str2HexStr(String str) {
        char[] chars = "0123456789ABCDEF".toCharArray();
        StringBuilder sb = new StringBuilder("");
        byte[] bs = str.getBytes();
        for (int i = 0; i < bs.length; ++i) {
            int bit = (bs[i] & 0xF0) >> 4;
            sb.append(chars[bit]);
            bit = bs[i] & 0xF;
            sb.append(chars[bit]);
        }
        return sb.toString().trim();
    }

    public static String jsonFormat(String json) {
        String message;
        if (TextUtils.isEmpty((CharSequence)json)) {
            return "Empty/Null json content";
        }
        try {
            json = json.trim();
            if (json.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(json);
                message = jsonObject.toString(4);
            } else if (json.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(json);
                message = jsonArray.toString(4);
            } else {
                message = json;
            }
        }
        catch (JSONException e) {
            message = json;
        }
        return message;
    }

    public static String xmlFormat(String xml) {
        String message;
        if (TextUtils.isEmpty((CharSequence)xml)) {
            return "Empty/Null xml content";
        }
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, xmlOutput);
            message = xmlOutput.getWriter().toString().replaceFirst(">", ">\n");
        }
        catch (TransformerException e) {
            message = xml;
        }
        return message;
    }
}

