/*
 * Decompiled with CFR 0.152.
 */
package com.gm.repository.di.module;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.gm.repository.http.GlobalHttpHandler;
import com.gm.repository.http.RequestInterceptor;
import com.gm.repository.rxerrorhandler.core.RxErrorHandler;
import com.gm.repository.rxerrorhandler.handler.listener.ResponseErrorListener;
import com.gm.repository.utils.DataHelper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dagger.Module;
import dagger.Provides;
import io.rx_cache2.internal.RxCache;
import io.victoralbertos.jolyglot.GsonSpeaker;
import io.victoralbertos.jolyglot.JolyglotGenerics;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

@Module
public class ClientModule {
    private static final int TIME_OUT = 10;
    private Application mApplication;

    public ClientModule(@NonNull Application application) {
        this.mApplication = application;
    }

    @Singleton
    @Provides
    Retrofit provideRetrofit(@Nullable RetrofitConfiguration configuration, Retrofit.Builder builder, OkHttpClient client, HttpUrl httpUrl) {
        builder.baseUrl(httpUrl).client(client).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        if (configuration != null) {
            configuration.configRetrofit((Context)this.mApplication, builder);
        }
        return builder.build();
    }

    @Singleton
    @Provides
    OkHttpClient provideClient(@Nullable OkhttpConfiguration configuration, OkHttpClient.Builder builder, Interceptor intercept, @Nullable List<Interceptor> interceptors, final @Nullable GlobalHttpHandler handler) {
        builder.connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).addNetworkInterceptor(intercept);
        if (handler != null) {
            builder.addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    return chain.proceed(handler.onHttpRequestBefore(chain, chain.request()));
                }
            });
        }
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                builder.addInterceptor(interceptor);
            }
        }
        if (configuration != null) {
            configuration.configOkhttp((Context)this.mApplication, builder);
        }
        return builder.build();
    }

    @Singleton
    @Provides
    Retrofit.Builder provideRetrofitBuilder() {
        return new Retrofit.Builder();
    }

    @Singleton
    @Provides
    OkHttpClient.Builder provideClientBuilder() {
        return new OkHttpClient.Builder();
    }

    @Singleton
    @Provides
    Interceptor provideInterceptor(RequestInterceptor intercept) {
        return intercept;
    }

    @Singleton
    @Provides
    RxErrorHandler provideRxErrorHandler(ResponseErrorListener listener) {
        return RxErrorHandler.builder().with((Context)this.mApplication).responseErrorListener(listener).build();
    }

    @Singleton
    @Provides
    Gson provideGson(@Nullable GsonConfiguration configuration) {
        GsonBuilder builder = new GsonBuilder();
        if (configuration != null) {
            configuration.configGson((Context)this.mApplication, builder);
        }
        return builder.create();
    }

    @Singleton
    @Provides
    RxCache provideRxCache(@Nullable RxCacheConfiguration configuration, @Named(value="RxCacheDirectory") File cacheDirectory) {
        RxCache.Builder builder = new RxCache.Builder();
        RxCache rxCache = null;
        if (configuration != null) {
            rxCache = configuration.configRxCache((Context)this.mApplication, builder);
        }
        if (rxCache != null) {
            return rxCache;
        }
        return builder.persistence(cacheDirectory, (JolyglotGenerics)new GsonSpeaker());
    }

    @Singleton
    @Provides
    @Named(value="RxCacheDirectory")
    File provideRxCacheDirectory(File cacheDir) {
        File cacheDirectory = new File(cacheDir, "RxCache");
        return DataHelper.makeDirs(cacheDirectory);
    }

    public static interface RxCacheConfiguration {
        public RxCache configRxCache(Context var1, RxCache.Builder var2);
    }

    public static interface GsonConfiguration {
        public void configGson(Context var1, GsonBuilder var2);
    }

    public static interface OkhttpConfiguration {
        public void configOkhttp(Context var1, OkHttpClient.Builder var2);
    }

    public static interface RetrofitConfiguration {
        public void configRetrofit(Context var1, Retrofit.Builder var2);
    }
}

