/*
 * Decompiled with CFR 0.152.
 */
package com.gm.repository.di.component;

import com.gm.repository.IRepositoryManager;
import com.gm.repository.RepositoryInjector;
import com.gm.repository.cache.Cache;
import com.gm.repository.di.component.RepositoryComponent;
import com.gm.repository.di.module.ClientModule;
import com.gm.repository.di.module.ClientModule_ProvideClientBuilderFactory;
import com.gm.repository.di.module.ClientModule_ProvideClientFactory;
import com.gm.repository.di.module.ClientModule_ProvideInterceptorFactory;
import com.gm.repository.di.module.ClientModule_ProvideRetrofitBuilderFactory;
import com.gm.repository.di.module.ClientModule_ProvideRetrofitFactory;
import com.gm.repository.di.module.ClientModule_ProvideRxCacheDirectoryFactory;
import com.gm.repository.di.module.ClientModule_ProvideRxCacheFactory;
import com.gm.repository.di.module.ClientModule_ProvideRxErrorHandlerFactory;
import com.gm.repository.di.module.DatabaseModule;
import com.gm.repository.di.module.RepositoryConfigModule;
import com.gm.repository.di.module.RepositoryConfigModule_ProvideBaseUrlFactory;
import com.gm.repository.di.module.RepositoryConfigModule_ProvideCacheFactoryFactory;
import com.gm.repository.di.module.RepositoryConfigModule_ProvideCacheFileFactory;
import com.gm.repository.di.module.RepositoryConfigModule_ProvideGlobalHttpHandlerFactory;
import com.gm.repository.di.module.RepositoryConfigModule_ProvideInterceptorsFactory;
import com.gm.repository.di.module.RepositoryConfigModule_ProvideOkhttpConfigurationFactory;
import com.gm.repository.di.module.RepositoryConfigModule_ProvidePrintHttpLogLevelFactory;
import com.gm.repository.di.module.RepositoryConfigModule_ProvideResponseErrorListenerFactory;
import com.gm.repository.di.module.RepositoryConfigModule_ProvideRetrofitConfigurationFactory;
import com.gm.repository.di.module.RepositoryConfigModule_ProvideRoomConfigurationFactory;
import com.gm.repository.di.module.RepositoryConfigModule_ProvideRxCacheConfigurationFactory;
import com.gm.repository.di.module.RepositoryModule;
import com.gm.repository.di.module.RepositoryModule_ProvideExtrasFactory;
import com.gm.repository.di.module.RepositoryModule_ProvideRepositoryManagerFactory;
import com.gm.repository.http.GlobalHttpHandler;
import com.gm.repository.http.RequestInterceptor;
import com.gm.repository.http.RequestInterceptor_Factory;
import com.gm.repository.rxerrorhandler.core.RxErrorHandler;
import com.gm.repository.rxerrorhandler.handler.listener.ResponseErrorListener;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.rx_cache2.internal.RxCache;
import java.io.File;
import java.util.List;
import javax.inject.Provider;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

public final class DaggerRepositoryComponent
implements RepositoryComponent {
    private Provider<ClientModule.RetrofitConfiguration> provideRetrofitConfigurationProvider;
    private Provider<Retrofit.Builder> provideRetrofitBuilderProvider;
    private Provider<ClientModule.OkhttpConfiguration> provideOkhttpConfigurationProvider;
    private Provider<OkHttpClient.Builder> provideClientBuilderProvider;
    private Provider<GlobalHttpHandler> provideGlobalHttpHandlerProvider;
    private Provider<RequestInterceptor.Level> providePrintHttpLogLevelProvider;
    private Provider<RequestInterceptor> requestInterceptorProvider;
    private Provider<Interceptor> provideInterceptorProvider;
    private Provider<List<Interceptor>> provideInterceptorsProvider;
    private Provider<OkHttpClient> provideClientProvider;
    private Provider<HttpUrl> provideBaseUrlProvider;
    private Provider<Retrofit> provideRetrofitProvider;
    private Provider<ClientModule.RxCacheConfiguration> provideRxCacheConfigurationProvider;
    private Provider<File> provideCacheFileProvider;
    private Provider<File> provideRxCacheDirectoryProvider;
    private Provider<RxCache> provideRxCacheProvider;
    private Provider<Cache.Factory> provideCacheFactoryProvider;
    private Provider<DatabaseModule.RoomConfiguration> provideRoomConfigurationProvider;
    private Provider<IRepositoryManager> provideRepositoryManagerProvider;
    private Provider<ResponseErrorListener> provideResponseErrorListenerProvider;
    private Provider<RxErrorHandler> provideRxErrorHandlerProvider;
    private Provider<Cache<String, Object>> provideExtrasProvider;

    private DaggerRepositoryComponent(Builder builder) {
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initialize(Builder builder) {
        this.provideRetrofitConfigurationProvider = DoubleCheck.provider(RepositoryConfigModule_ProvideRetrofitConfigurationFactory.create(builder.repositoryConfigModule));
        this.provideRetrofitBuilderProvider = DoubleCheck.provider(ClientModule_ProvideRetrofitBuilderFactory.create(builder.clientModule));
        this.provideOkhttpConfigurationProvider = DoubleCheck.provider(RepositoryConfigModule_ProvideOkhttpConfigurationFactory.create(builder.repositoryConfigModule));
        this.provideClientBuilderProvider = DoubleCheck.provider(ClientModule_ProvideClientBuilderFactory.create(builder.clientModule));
        this.provideGlobalHttpHandlerProvider = DoubleCheck.provider(RepositoryConfigModule_ProvideGlobalHttpHandlerFactory.create(builder.repositoryConfigModule));
        this.providePrintHttpLogLevelProvider = DoubleCheck.provider(RepositoryConfigModule_ProvidePrintHttpLogLevelFactory.create(builder.repositoryConfigModule));
        this.requestInterceptorProvider = DoubleCheck.provider(RequestInterceptor_Factory.create(this.provideGlobalHttpHandlerProvider, this.providePrintHttpLogLevelProvider));
        this.provideInterceptorProvider = DoubleCheck.provider(ClientModule_ProvideInterceptorFactory.create(builder.clientModule, this.requestInterceptorProvider));
        this.provideInterceptorsProvider = DoubleCheck.provider(RepositoryConfigModule_ProvideInterceptorsFactory.create(builder.repositoryConfigModule));
        this.provideClientProvider = DoubleCheck.provider(ClientModule_ProvideClientFactory.create(builder.clientModule, this.provideOkhttpConfigurationProvider, this.provideClientBuilderProvider, this.provideInterceptorProvider, this.provideInterceptorsProvider, this.provideGlobalHttpHandlerProvider));
        this.provideBaseUrlProvider = DoubleCheck.provider(RepositoryConfigModule_ProvideBaseUrlFactory.create(builder.repositoryConfigModule));
        this.provideRetrofitProvider = DoubleCheck.provider(ClientModule_ProvideRetrofitFactory.create(builder.clientModule, this.provideRetrofitConfigurationProvider, this.provideRetrofitBuilderProvider, this.provideClientProvider, this.provideBaseUrlProvider));
        this.provideRxCacheConfigurationProvider = DoubleCheck.provider(RepositoryConfigModule_ProvideRxCacheConfigurationFactory.create(builder.repositoryConfigModule));
        this.provideCacheFileProvider = DoubleCheck.provider(RepositoryConfigModule_ProvideCacheFileFactory.create(builder.repositoryConfigModule));
        this.provideRxCacheDirectoryProvider = DoubleCheck.provider(ClientModule_ProvideRxCacheDirectoryFactory.create(builder.clientModule, this.provideCacheFileProvider));
        this.provideRxCacheProvider = DoubleCheck.provider(ClientModule_ProvideRxCacheFactory.create(builder.clientModule, this.provideRxCacheConfigurationProvider, this.provideRxCacheDirectoryProvider));
        this.provideCacheFactoryProvider = DoubleCheck.provider(RepositoryConfigModule_ProvideCacheFactoryFactory.create(builder.repositoryConfigModule));
        this.provideRoomConfigurationProvider = DoubleCheck.provider(RepositoryConfigModule_ProvideRoomConfigurationFactory.create(builder.repositoryConfigModule));
        this.provideRepositoryManagerProvider = DoubleCheck.provider(RepositoryModule_ProvideRepositoryManagerFactory.create(builder.repositoryModule, this.provideRetrofitProvider, this.provideRxCacheProvider, this.provideCacheFactoryProvider, this.provideRoomConfigurationProvider));
        this.provideResponseErrorListenerProvider = DoubleCheck.provider(RepositoryConfigModule_ProvideResponseErrorListenerFactory.create(builder.repositoryConfigModule));
        this.provideRxErrorHandlerProvider = DoubleCheck.provider(ClientModule_ProvideRxErrorHandlerFactory.create(builder.clientModule, this.provideResponseErrorListenerProvider));
        this.provideExtrasProvider = DoubleCheck.provider(RepositoryModule_ProvideExtrasFactory.create(builder.repositoryModule, this.provideCacheFactoryProvider));
    }

    @Override
    public IRepositoryManager repositoryManager() {
        return (IRepositoryManager)this.provideRepositoryManagerProvider.get();
    }

    @Override
    public RxErrorHandler rxErrorHandler() {
        return (RxErrorHandler)this.provideRxErrorHandlerProvider.get();
    }

    @Override
    public OkHttpClient okHttpClient() {
        return (OkHttpClient)this.provideClientProvider.get();
    }

    @Override
    public File cacheFile() {
        return (File)this.provideCacheFileProvider.get();
    }

    @Override
    public Cache<String, Object> extras() {
        return (Cache)this.provideExtrasProvider.get();
    }

    @Override
    public void inject(RepositoryInjector repositoryInjector) {
    }

    public static final class Builder {
        private RepositoryConfigModule repositoryConfigModule;
        private ClientModule clientModule;
        private RepositoryModule repositoryModule;

        private Builder() {
        }

        public RepositoryComponent build() {
            if (this.repositoryConfigModule == null) {
                throw new IllegalStateException(RepositoryConfigModule.class.getCanonicalName() + " must be set");
            }
            if (this.clientModule == null) {
                throw new IllegalStateException(ClientModule.class.getCanonicalName() + " must be set");
            }
            if (this.repositoryModule == null) {
                throw new IllegalStateException(RepositoryModule.class.getCanonicalName() + " must be set");
            }
            return new DaggerRepositoryComponent(this);
        }

        public Builder repositoryModule(RepositoryModule repositoryModule) {
            this.repositoryModule = (RepositoryModule)Preconditions.checkNotNull((Object)repositoryModule);
            return this;
        }

        public Builder clientModule(ClientModule clientModule) {
            this.clientModule = (ClientModule)Preconditions.checkNotNull((Object)clientModule);
            return this;
        }

        public Builder repositoryConfigModule(RepositoryConfigModule repositoryConfigModule) {
            this.repositoryConfigModule = (RepositoryConfigModule)Preconditions.checkNotNull((Object)repositoryConfigModule);
            return this;
        }
    }
}

