/*
 * Decompiled with CFR 0.152.
 */
package com.gm.repository;

import android.app.Application;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.content.Context;
import com.gm.repository.IRepositoryManager;
import com.gm.repository.cache.Cache;
import com.gm.repository.cache.CacheType;
import com.gm.repository.di.module.DatabaseModule;
import com.gm.repository.utils.Preconditions;
import dagger.Lazy;
import io.rx_cache2.internal.RxCache;
import javax.inject.Inject;
import javax.inject.Singleton;
import retrofit2.Retrofit;

@Singleton
public class RepositoryManager
implements IRepositoryManager {
    private Application mApplication;
    private Lazy<Retrofit> mRetrofit;
    private Lazy<RxCache> mRxCache;
    private Cache<String, Object> mRetrofitServiceCache;
    private Cache<String, Object> mCacheServiceCache;
    private Cache<String, Object> mRoomDatabaseCache;
    private final Cache.Factory mCacheFactory;
    private DatabaseModule.RoomConfiguration mRoomConfiguration;

    @Inject
    public RepositoryManager(Application application, Lazy<Retrofit> retrofit, Lazy<RxCache> rxCache, Cache.Factory cacheFactory, DatabaseModule.RoomConfiguration roomConfiguration) {
        this.mApplication = application;
        this.mRetrofit = retrofit;
        this.mRxCache = rxCache;
        this.mCacheFactory = cacheFactory;
        this.mRoomConfiguration = roomConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T obtainRetrofitService(Class<T> service) {
        Object retrofitService;
        if (this.mRetrofitServiceCache == null) {
            this.mRetrofitServiceCache = this.mCacheFactory.build(CacheType.RETROFIT_SERVICE_CACHE_TYPE);
        }
        Preconditions.checkNotNull(this.mRetrofitServiceCache, "Cannot return null from a Cache.Factory#build(int) method");
        Cache<String, Object> cache = this.mRetrofitServiceCache;
        synchronized (cache) {
            retrofitService = this.mRetrofitServiceCache.get(service.getName());
            if (retrofitService == null) {
                retrofitService = ((Retrofit)this.mRetrofit.get()).create(service);
                this.mRetrofitServiceCache.put(service.getName(), retrofitService);
            }
        }
        return (T)retrofitService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T obtainCacheService(Class<T> cache) {
        Object cacheService;
        if (this.mCacheServiceCache == null) {
            this.mCacheServiceCache = this.mCacheFactory.build(CacheType.CACHE_SERVICE_CACHE_TYPE);
        }
        Preconditions.checkNotNull(this.mCacheServiceCache, "Cannot return null from a Cache.Factory#build(int) method");
        Cache<String, Object> cache2 = this.mCacheServiceCache;
        synchronized (cache2) {
            cacheService = this.mCacheServiceCache.get(cache.getName());
            if (cacheService == null) {
                cacheService = ((RxCache)this.mRxCache.get()).using(cache);
                this.mCacheServiceCache.put(cache.getName(), cacheService);
            }
        }
        return (T)cacheService;
    }

    @Override
    public void clearAllCache() {
        ((RxCache)this.mRxCache.get()).evictAll();
    }

    @Override
    public Context getContext() {
        return this.mApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <DB extends RoomDatabase> DB obtainRoomDatabase(Class<DB> database, String dbName) {
        RoomDatabase roomDatabase;
        if (this.mRoomDatabaseCache == null) {
            this.mRoomDatabaseCache = this.mCacheFactory.build(CacheType.ROOM_DATABASE_CACHE_TYPE);
        }
        Preconditions.checkNotNull(this.mRoomDatabaseCache, "Cannot return null from a Cache.Factory#build(int) method");
        Cache<String, Object> cache = this.mRoomDatabaseCache;
        synchronized (cache) {
            roomDatabase = (RoomDatabase)this.mRoomDatabaseCache.get(database.getName());
            if (roomDatabase == null) {
                RoomDatabase.Builder builder = Room.databaseBuilder((Context)this.mApplication, database, (String)dbName);
                if (this.mRoomConfiguration != null) {
                    this.mRoomConfiguration.configRoom((Context)this.mApplication, builder);
                }
                roomDatabase = builder.build();
                this.mRoomDatabaseCache.put(database.getName(), roomDatabase);
            }
        }
        return (DB)roomDatabase;
    }
}

