/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import com.google.adk.tools.mcp.McpTransportBuilder;
import com.google.adk.tools.mcp.SseServerParameters;
import com.google.common.collect.ImmutableMap;
import io.modelcontextprotocol.client.transport.HttpClientSseClientTransport;
import io.modelcontextprotocol.client.transport.ServerParameters;
import io.modelcontextprotocol.client.transport.StdioClientTransport;
import io.modelcontextprotocol.spec.McpClientTransport;
import java.util.Collection;
import java.util.Optional;

public class DefaultMcpTransportBuilder
implements McpTransportBuilder {
    @Override
    public McpClientTransport build(Object connectionParams) {
        if (connectionParams instanceof ServerParameters) {
            ServerParameters serverParameters = (ServerParameters)connectionParams;
            return new StdioClientTransport(serverParameters);
        }
        if (connectionParams instanceof SseServerParameters) {
            SseServerParameters sseServerParams = (SseServerParameters)connectionParams;
            return HttpClientSseClientTransport.builder((String)sseServerParams.url()).sseEndpoint("sse").customizeRequest(builder -> Optional.ofNullable(sseServerParams.headers()).map(ImmutableMap::entrySet).stream().flatMap(Collection::stream).forEach(entry -> builder.header((String)entry.getKey(), Optional.ofNullable(entry.getValue()).map(Object::toString).orElse("")))).build();
        }
        throw new IllegalArgumentException("DefaultMcpTransportBuilder supports only ServerParameters or SseServerParameters, but got " + connectionParams.getClass().getName());
    }
}

