/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.sessions;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class State
implements ConcurrentMap<String, Object> {
    public static final String APP_PREFIX = "app:";
    public static final String USER_PREFIX = "user:";
    public static final String TEMP_PREFIX = "temp:";
    private static final Object REMOVED = new Object();
    private final ConcurrentMap<String, Object> state;
    private final ConcurrentMap<String, Object> delta;

    public State(ConcurrentMap<String, Object> state) {
        this(state, new ConcurrentHashMap<String, Object>());
    }

    public State(ConcurrentMap<String, Object> state, ConcurrentMap<String, Object> delta) {
        this.state = Objects.requireNonNull(state);
        this.delta = delta;
    }

    @Override
    public void clear() {
        this.state.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.state.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.state.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.state.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State other = (State)o;
        return this.state.equals(other.state);
    }

    @Override
    public Object get(Object key) {
        return this.state.get(key);
    }

    @Override
    public int hashCode() {
        return this.state.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.state.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        Object oldValue = this.state.put(key, value);
        this.delta.put(key, value);
        return oldValue;
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        Object existingValue = this.state.putIfAbsent(key, value);
        if (existingValue == null) {
            this.delta.put(key, value);
        }
        return existingValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.state.putAll(m);
        this.delta.putAll(m);
    }

    @Override
    public Object remove(Object key) {
        if (this.state.containsKey(key)) {
            this.delta.put((String)key, REMOVED);
        }
        return this.state.remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean removed = this.state.remove(key, value);
        if (removed) {
            this.delta.put((String)key, REMOVED);
        }
        return removed;
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        boolean replaced = this.state.replace(key, oldValue, newValue);
        if (replaced) {
            this.delta.put(key, newValue);
        }
        return replaced;
    }

    @Override
    public Object replace(String key, Object value) {
        Object oldValue = this.state.replace(key, value);
        if (oldValue != null) {
            this.delta.put(key, value);
        }
        return oldValue;
    }

    @Override
    public int size() {
        return this.state.size();
    }

    @Override
    public Collection<Object> values() {
        return this.state.values();
    }

    public boolean hasDelta() {
        return !this.delta.isEmpty();
    }
}

