/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.runner;

import com.google.adk.Telemetry;
import com.google.adk.agents.ActiveStreamingTool;
import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.LiveRequestQueue;
import com.google.adk.agents.LlmAgent;
import com.google.adk.agents.RunConfig;
import com.google.adk.artifacts.BaseArtifactService;
import com.google.adk.events.Event;
import com.google.adk.sessions.BaseSessionService;
import com.google.adk.sessions.Session;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.FunctionTool;
import com.google.adk.utils.CollectionUtils;
import com.google.common.collect.ImmutableList;
import com.google.genai.types.AudioTranscriptionConfig;
import com.google.genai.types.Content;
import com.google.genai.types.Modality;
import com.google.genai.types.Part;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Runner {
    private final BaseAgent agent;
    private final String appName;
    private final BaseArtifactService artifactService;
    private final BaseSessionService sessionService;

    public Runner(BaseAgent agent, String appName, BaseArtifactService artifactService, BaseSessionService sessionService) {
        this.agent = agent;
        this.appName = appName;
        this.artifactService = artifactService;
        this.sessionService = sessionService;
    }

    public BaseAgent agent() {
        return this.agent;
    }

    public String appName() {
        return this.appName;
    }

    public BaseArtifactService artifactService() {
        return this.artifactService;
    }

    public BaseSessionService sessionService() {
        return this.sessionService;
    }

    private void appendNewMessageToSession(Session session, Content newMessage, InvocationContext invocationContext, boolean saveInputBlobsAsArtifacts) {
        if (newMessage.parts().isEmpty()) {
            throw new IllegalArgumentException("No parts in the new_message.");
        }
        if (this.artifactService != null && saveInputBlobsAsArtifacts) {
            for (int i = 0; i < ((List)newMessage.parts().get()).size(); ++i) {
                Part part = (Part)((List)newMessage.parts().get()).get(i);
                if (part.inlineData().isEmpty()) continue;
                String fileName = "artifact_" + invocationContext.invocationId() + "_" + i;
                Single<Integer> unused = this.artifactService.saveArtifact(this.appName, session.userId(), session.id(), fileName, part);
                ((List)newMessage.parts().get()).set(i, Part.fromText((String)("Uploaded file: " + fileName + ". It has been saved to the artifacts")));
            }
        }
        Event event = Event.builder().id(Event.generateEventId()).invocationId(invocationContext.invocationId()).author("user").content(Optional.of(newMessage)).build();
        this.sessionService.appendEvent(session, event);
    }

    public Flowable<Event> runAsync(String userId, String sessionId, Content newMessage, RunConfig runConfig) {
        Maybe<Session> maybeSession = this.sessionService.getSession(this.appName, userId, sessionId, Optional.empty());
        return maybeSession.switchIfEmpty((SingleSource)Single.error((Throwable)new IllegalArgumentException(String.format("Session not found: %s for user %s", sessionId, userId)))).flatMapPublisher(session -> this.runAsync((Session)session, newMessage, runConfig));
    }

    public Flowable<Event> runAsync(String userId, String sessionId, Content newMessage) {
        return this.runAsync(userId, sessionId, newMessage, RunConfig.builder().build());
    }

    public Flowable<Event> runAsync(Session session, Content newMessage, RunConfig runConfig) {
        Flowable flowable;
        block8: {
            Span span = Telemetry.getTracer().spanBuilder("invocation").startSpan();
            Scope scope = span.makeCurrent();
            try {
                flowable = Flowable.just((Object)session).flatMap(sess -> {
                    BaseAgent rootAgent = this.agent;
                    InvocationContext invocationContext = InvocationContext.create(this.sessionService, this.artifactService, InvocationContext.newInvocationContextId(), rootAgent, sess, newMessage, runConfig);
                    if (newMessage != null) {
                        this.appendNewMessageToSession((Session)sess, newMessage, invocationContext, runConfig.saveInputBlobsAsArtifacts());
                    }
                    invocationContext.agent(this.findAgentToRun((Session)sess, rootAgent));
                    Flowable<Event> events = invocationContext.agent().runAsync(invocationContext);
                    return events.doOnNext(event -> this.sessionService.appendEvent((Session)sess, (Event)event));
                }).doOnError(throwable -> {
                    span.setStatus(StatusCode.ERROR, "Error in runAsync Flowable execution");
                    span.recordException(throwable);
                }).doFinally(() -> ((Span)span).end());
                if (scope == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                    }
                    throw throwable2;
                }
                catch (Throwable t) {
                    span.setStatus(StatusCode.ERROR, "Error during runAsync synchronous setup");
                    span.recordException(t);
                    span.end();
                    return Flowable.error((Throwable)t);
                }
            }
            scope.close();
        }
        return flowable;
    }

    private InvocationContext newInvocationContextForLive(Session session, Optional<LiveRequestQueue> liveRequestQueue, RunConfig runConfig) {
        RunConfig.Builder runConfigBuilder = RunConfig.builder(runConfig);
        if (!CollectionUtils.isNullOrEmpty(runConfig.responseModalities()) && liveRequestQueue.isPresent()) {
            if (CollectionUtils.isNullOrEmpty(runConfig.responseModalities())) {
                runConfigBuilder.setResponseModalities((Iterable<Modality>)ImmutableList.of((Object)new Modality(Modality.Known.AUDIO)));
                if (runConfig.outputAudioTranscription() == null) {
                    runConfigBuilder.setOutputAudioTranscription(AudioTranscriptionConfig.builder().build());
                }
            } else if (!runConfig.responseModalities().contains((Object)new Modality(Modality.Known.TEXT)) && runConfig.outputAudioTranscription() == null) {
                runConfigBuilder.setOutputAudioTranscription(AudioTranscriptionConfig.builder().build());
            }
        }
        return this.newInvocationContext(session, liveRequestQueue, runConfigBuilder.build());
    }

    private InvocationContext newInvocationContext(Session session, Optional<LiveRequestQueue> liveRequestQueue, RunConfig runConfig) {
        BaseAgent rootAgent = this.agent;
        InvocationContext invocationContext = InvocationContext.create(this.sessionService, this.artifactService, rootAgent, session, liveRequestQueue.orElse(null), runConfig);
        invocationContext.agent(this.findAgentToRun(session, rootAgent));
        return invocationContext;
    }

    public Flowable<Event> runLive(Session session, LiveRequestQueue liveRequestQueue, RunConfig runConfig) {
        Flowable flowable;
        block11: {
            Span span = Telemetry.getTracer().spanBuilder("invocation").startSpan();
            Scope scope = span.makeCurrent();
            try {
                InvocationContext invocationContext = this.newInvocationContextForLive(session, Optional.of(liveRequestQueue), runConfig);
                if (invocationContext.agent() instanceof LlmAgent) {
                    LlmAgent agent = (LlmAgent)invocationContext.agent();
                    for (BaseTool tool : agent.tools()) {
                        if (!(tool instanceof FunctionTool)) continue;
                        FunctionTool functionTool = (FunctionTool)tool;
                        for (Parameter parameter : functionTool.func().getParameters()) {
                            if (!parameter.getType().equals(LiveRequestQueue.class)) continue;
                            invocationContext.activeStreamingTools().put(functionTool.name(), new ActiveStreamingTool(new LiveRequestQueue()));
                        }
                    }
                }
                flowable = invocationContext.agent().runLive(invocationContext).doOnNext(event -> this.sessionService.appendEvent(session, (Event)event)).doOnError(throwable -> {
                    span.setStatus(StatusCode.ERROR, "Error in runLive Flowable execution");
                    span.recordException(throwable);
                }).doFinally(() -> ((Span)span).end());
                if (scope == null) break block11;
            }
            catch (Throwable throwable2) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                    }
                    throw throwable2;
                }
                catch (Throwable t) {
                    span.setStatus(StatusCode.ERROR, "Error during runLive synchronous setup");
                    span.recordException(t);
                    span.end();
                    return Flowable.error((Throwable)t);
                }
            }
            scope.close();
        }
        return flowable;
    }

    public Flowable<Event> runLive(String userId, String sessionId, LiveRequestQueue liveRequestQueue, RunConfig runConfig) {
        return this.sessionService.getSession(this.appName, userId, sessionId, Optional.empty()).flatMapPublisher(session -> {
            if (session == null) {
                return Flowable.error((Throwable)new IllegalArgumentException(String.format("Session not found: %s for user %s", sessionId, userId)));
            }
            return this.runLive((Session)session, liveRequestQueue, runConfig);
        });
    }

    public Flowable<Event> runWithSessionId(String sessionId, Content newMessage, RunConfig runConfig) {
        return this.runAsync("tmp-user", sessionId, newMessage, runConfig);
    }

    private boolean isTransferableAcrossAgentTree(BaseAgent agentToRun) {
        for (BaseAgent current = agentToRun; current != null; current = current.parentAgent()) {
            if (!(current instanceof LlmAgent)) {
                return false;
            }
            LlmAgent agent = (LlmAgent)current;
            if (!agent.disallowTransferToParent()) continue;
            return false;
        }
        return true;
    }

    private BaseAgent findAgentToRun(Session session, BaseAgent rootAgent) {
        ArrayList<Event> events = new ArrayList<Event>(session.events());
        Collections.reverse(events);
        for (Event event : events) {
            String author = event.author();
            if (author.equals("user")) continue;
            if (author.equals(rootAgent.name())) {
                return rootAgent;
            }
            BaseAgent agent = rootAgent.findSubAgent(author);
            if (agent == null || !this.isTransferableAcrossAgentTree(agent)) continue;
            return agent;
        }
        return rootAgent;
    }
}

