/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.memory;

import com.google.adk.events.Event;
import com.google.adk.memory.BaseMemoryService;
import com.google.adk.memory.MemoryEntry;
import com.google.adk.memory.SearchMemoryResponse;
import com.google.adk.sessions.Session;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.genai.types.Part;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class InMemoryMemoryService
implements BaseMemoryService {
    private static final Pattern WORD_PATTERN = Pattern.compile("[A-Za-z]+");
    private final Map<String, Map<String, List<Event>>> sessionEvents = new ConcurrentHashMap<String, Map<String, List<Event>>>();

    private static String userKey(String appName, String userId) {
        return appName + "/" + userId;
    }

    @Override
    public Completable addSessionToMemory(Session session) {
        return Completable.fromAction(() -> {
            String key = InMemoryMemoryService.userKey(session.appName(), session.userId());
            Map userSessions = this.sessionEvents.computeIfAbsent(key, k -> new ConcurrentHashMap());
            ImmutableList nonEmptyEvents = (ImmutableList)session.events().stream().filter(event -> event.content().isPresent() && event.content().get().parts().isPresent() && !((List)event.content().get().parts().get()).isEmpty()).collect(ImmutableList.toImmutableList());
            userSessions.put(session.id(), nonEmptyEvents);
        });
    }

    @Override
    public Single<SearchMemoryResponse> searchMemory(String appName, String userId, String query) {
        return Single.fromCallable(() -> {
            String key = InMemoryMemoryService.userKey(appName, userId);
            if (!this.sessionEvents.containsKey(key)) {
                return SearchMemoryResponse.builder().build();
            }
            Map<String, List<Event>> userSessions = this.sessionEvents.get(key);
            ImmutableSet wordsInQuery = ImmutableSet.copyOf((Object[])query.toLowerCase(Locale.ROOT).split("\\s+"));
            ArrayList<MemoryEntry> matchingMemories = new ArrayList<MemoryEntry>();
            for (List<Event> eventsInSession : userSessions.values()) {
                for (Event event : eventsInSession) {
                    if (event.content().isEmpty() || event.content().get().parts().isEmpty()) continue;
                    HashSet<String> wordsInEvent = new HashSet<String>();
                    for (Part part : (List)event.content().get().parts().get()) {
                        if (Strings.isNullOrEmpty((String)((String)part.text().get()))) continue;
                        Matcher matcher = WORD_PATTERN.matcher((CharSequence)part.text().get());
                        while (matcher.find()) {
                            wordsInEvent.add(matcher.group().toLowerCase(Locale.ROOT));
                        }
                    }
                    if (wordsInEvent.isEmpty() || Collections.disjoint(wordsInQuery, wordsInEvent)) continue;
                    MemoryEntry memory = MemoryEntry.builder().setContent(event.content().get()).setAuthor(event.author()).setTimestamp(this.formatTimestamp(event.timestamp())).build();
                    matchingMemories.add(memory);
                }
            }
            return SearchMemoryResponse.builder().setMemories((ImmutableList<MemoryEntry>)ImmutableList.copyOf(matchingMemories)).build();
        });
    }

    private String formatTimestamp(long timestamp) {
        return Instant.ofEpochSecond(timestamp).toString();
    }
}

